/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros;

// java packages
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.proofsecure.paros.document.WebLink;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpHeader;
import com.proofsecure.paros.network.HttpInputStream;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpOutputStream;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.util.Util;
/*

This class is secure because all the following measures are done:
- HTTPS login with POST
- check IP rules
- no cache and no autocomplete
- check URL paths outside DocRoot by comparing CanonicalPath with AbsolutePath
- only can access webpages with valid cookie. Check cookie before display pages (except images)
- directory URI can not be accessed
- remove cookie at server and client after logout
- with 20min timeout period

Limitation:
- can bruce-force the cookie as it is digit only.  But, this is migrated with IP rules checking 
- no '\\', '//' escape code checking, but no related security holes can be found.

*/
public class AdminServer extends Proxy{
	public static int ADMIN_SERVER_PORT = 8099;
	public static String ADMIN_SERVER_NAME = "127.0.0.1";		
	public static Vector IPAllowed = new Vector();
//	public static String DOCROOT = "d:" + File.separator + "myparos" + File.separator + "adminpages";
	public static String DOCROOT = "." + File.separator + "adminpages";
	private static Session session = new Session();
	private static String authCode;

	AdminServer(String proxyIP, int port){
		super(proxyIP, port);
		try{
			DOCROOT = (new File(DOCROOT)).getCanonicalPath();
		}
		catch(IOException e){
		}
		IPAllowed.add("127.0.0.1");  // allow only localhost to access by default

		Random	randomGenerator = new Random();		
		authCode = Long.toString(Math.abs(randomGenerator.nextLong()));
	}
	
	String getAuthCode(){
		return authCode;
	}

	Session getSession(){
		return session;
	}

	public synchronized boolean startServer() {
		
		if (mIsProxyRunning) {
			return false;
		}
		
		mIsProxyRunning	= false;
		mIsExit			= false;
		
        myThread = new Thread(this);
        myThread.setDaemon(true);
   	    myThread.setPriority(Thread.NORM_PRIORITY+1);
		myThread.start();

		try {
			mProxySock = Global.ssl.listen(mProxyPort, 300, InetAddress.getByName(mProxyIP));
			
	    	mProxySock.setSoTimeout(PORT_TIME_OUT);
			mIsProxyRunning = true;
			System.out.println("Admin server started.");

		} catch (Exception e) {
			System.out.println("Error: Cannot open port.");
			return false;
		}
		
		return true;
	}

	// called by ProxyHandler for checking IP rules during connecting to Admin port via Paros Proxy
	public boolean isAccessAllowed(Socket in){
		// check the connection IP address with pre-defined IP rules
		InetAddress clientAddr = in.getInetAddress();
//		try{
//			if (clientAddr.getHostAddress().equals(InetAddress.getLocalHost().getHostAddress())){
//			if (clientAddr.getHostAddress().equals(server.IPAllowed)){
			if (IPAllowed.indexOf(clientAddr.getHostAddress()) != -1){
				return true;				
			}
			else{
				return false;
			}
//		}catch(UnknownHostException e){
//			return false;
//		}
		
	}

	public void run() {

		Socket clientSock = null;

		while (!mIsExit) {

			try {
				if (mIsProxyRunning) {
					AdminHandler p = new AdminHandler(this);
					clientSock = mProxySock.accept();
					p.start(clientSock);
				} else {
					Util.sleep(100);
				}
			} catch (IOException e) {
			}

		}


	}

	public String getDocRoot(){
		return DOCROOT;
	}

	public static void main(String[] args) {
		
		AdminServer server = new AdminServer(ADMIN_SERVER_NAME, ADMIN_SERVER_PORT);
		
		boolean success;
	    if ((success = server.startServer()) == false) {
	      System.out.println("Error Admin server initialization, please exit");
	    }

	    while (true) {
	      System.gc();
	      Util.sleep(800000);
	    }

	}

	
}




class AdminHandler extends ProxyHandler {
	private static AdminServer server = null;
	private String sessionID = null;
	private boolean isNewSession = false;
	
	AdminHandler () {
		super();
	}

	AdminHandler (AdminServer s) {
		super();
		server = s;
	}

	public void start(Socket sock) {
		mInSocket = sock;
//		originHandler = ProxyHandler.getOriginatingTunnelProcess(mInSocket.getPort());
		super.start(sock, true);

	}

	 protected void disconnect() {
	 	try{
//			while (!originHandler.isTunnelInputBufferEmpty()) {
//				Tools.sleep(100);
//			}
	
//			originHandler.setDisconnect(true);
			mClientHttpOut.close();
//			Util.closeSocket(mOutSocket);
		}
		catch(Exception e){
			//e.printStackTrace();
		}

	}


	protected void assumeProxy() {
		mClientHttpInReqHeader.setAbsoluteUriRequired(false);
	}
	
	/**
	Process after request header is read.  Overriden by SSLProxyHandler.
	*/
	protected void afterRequestHeaderRead(HttpRequestHeader req) {
		req.setSecure(true);
//		req.setHostName(originHandler.hostName);
//		req.setHostPort(originHandler.hostPort);
	}

	private void sendError() throws Exception{
			sendResponse(server.getDocRoot() + File.separator + "error.htm");
	}

	private void sendError(String idata) throws Exception{
		// show cache pages
		String crlf = "\r\n";
		String data = "<html><body link=#0000FF alink=#0000FF vlink=#0000FF>" + crlf;
		
		data += idata + "<br>" + crlf;

		data += "</body></html>" + crlf;
		sendDataResponse(data);			
	}

	private void mnuCache(Hashtable param) throws Exception{
		// return file /cache/lower.htm, which in turn retrieve /cache/status.htm, /cache/blank.htm
		String command;
		if ((command = (String)param.get("Submit"))!=null){					
			if (command.equalsIgnoreCase("Clear Cache")){
				Global.webDoc.clear();
			}
		}

		sendResponse(server.getDocRoot() + File.separator + "cache" + File.separator + "lower.htm");
	}

	private void mnuCacheFunction(Hashtable param) throws Exception{
		String crlf = "\r\n";

		String command;
		if ((command = (String)param.get("Submit"))!=null){					
			if (command.equalsIgnoreCase("Toggle Mode")){
				// toggle the online/offline mode
				Global.isOffline = (Global.isOffline)?false:true;	
				String mode = (Global.isOffline)?"Offline Mode":"Online Mode";	
				Global.parosFrame.logAppend("===================== Switched to " + mode + " =====================" + crlf);
			}			
		}

		// return cache status for /cache/status request
		String data = "<html><body>" + crlf;

		String mode = (Global.isOffline)?"On":"Off";
		data += "Offline Mode: " + mode + crlf;
//		data +=	"<form name=form1 action=javascript:window.location.replace('/cache/status')>" + crlf;
		data +=	"<form name=form1 method=post action=''>" + crlf;
		data += "<input type=submit name=Submit value='Toggle Mode'></form>" + crlf;
		data +=	"<form name=form2 action=javascript:window.location.replace('/cache') target=_parent>" + crlf;
		data += "<input type=submit name=Submit value='Refresh Cache'></form>" + crlf;
		data +=	"<form name=form2 method=post action='/cache' target=_parent>" + crlf;
		data += "<input type=submit name=Submit value='Clear Cache'></form>" + crlf;

		data += "</body></html>" + crlf;
		sendDataResponse(data);		
	}

	private void mnuCacheContent() throws Exception{
		// show cache pages
		String crlf = "\r\n";
		String data = "<html><body link=#0000FF alink=#0000FF vlink=#0000FF>" + crlf;
		
		data += "Total no. of cached URLs = " + Global.webDoc.getHistorySize() + " <br>";
		data += "<font size=2>";
		data += "<br>Cached pages with 'html' tag embedded in the body are shown in blue color, ";
		data += "other pages are shown in light grey color. ";
		data += "Note that you may not be able to see those pages with 3xx status codes as they are cached in web browser, but not in Paros." + "<br>" + crlf;
		data += "<br>In order to view the cache, please switch/toggle to Offline mode first. Otherwise, clicking the following links will retrieve pages from website directly." + "<br>" + crlf;
		data += "<br>[status code]  website_URL" + "<br>" + crlf;
		data += "</font>";

		data += Global.webDoc.toHTML();

		data += "</body></html>" + crlf;
		sendDataResponse(data);		

	}

	
	private void sendResponse(String path) throws Exception{
		// don't add sendError() statement inside, to prevent deadloop
	    File dfile = new File(path);
	    int CLen = (int)(dfile.length());
	    byte[] buffer=new byte[4096];
	
	    int len;

        // File or directory exists
        // no checking for security breach, i.e. paths outside docroot
		boolean exists = dfile.exists() && (dfile.length()!=0); 
	    if (!exists ){	    		    		    	
			String lastsite = server.getSession().getLastSite(sessionID);    
	    	if (lastsite !=null){
	    		// it maybe a cache request
				int i;
				String newpath = null, sitename=null, sitepath=null;
				if ((i = path.indexOf(server.getDocRoot()))!=-1)
					 newpath = path.substring(server.getDocRoot().length() +1);

				if ((i = newpath.indexOf("/"))!=-1){
					 sitename = newpath.substring(0, i);  // e.g. www.domain.com
					 sitepath = newpath.substring(i);   // e.g. /images/xx.gif
				}
//	    		System.out.println("PATH " + newpath);
	    		System.out.println("site " + sitename);
	    		System.out.println("sitepath " + sitepath);

				if (sitename != null && sitepath != null ){
	    			ParsedEntity	entity	= Global.treePanel.getRoot();
//					mStartEntity.getHostName();  		
					boolean siteflag = false;
					for (int d=0; d<entity.getChildCount(); d++) {
						try {
							if (((ParsedEntity)entity.getChildAt(d)).getHostName().equalsIgnoreCase(sitename)){
								siteflag = true;
								break;
							}
						} catch (Exception e) {
							e.printStackTrace();
							
						}
					}
					
					if (!siteflag){
						sitename = lastsite;
						sitepath = "/" + newpath;						
					}
					
					WebLink doc = (WebLink)Global.webDoc.getHistory(sitename, sitepath);
//					if (doc==null)
//						System.out.println("no doc");
					if (doc != null && mClientHttpOut != null){
						if (doc.getRespHeader()!=null)
							mClientHttpOut.write(doc.getRespHeader());
						if (doc.getRespContent()!=null)
							mClientHttpOut.write(doc.getRespContent());
						else
//						System.out.println("no doc content");							
						mClientHttpOut.flush();

						if (server != null && sessionID != null)
							server.getSession().updateSession(sessionID, sitename);
						return;
						
					}
					
				}
	    		

				dfile = new File(server.getDocRoot() + File.separator + "error.htm");
				CLen = (int)(dfile.length());				

//	    		return;	
	    	}
	    	else{
				dfile = new File(server.getDocRoot() + File.separator + "error.htm");
				CLen = (int)(dfile.length());
			}
	    }

	    FileInputStream fileIn = new FileInputStream(dfile);

		HttpResponseHeader header = createResponseHeader(CLen);
	    mClientHttpOut.write(header);
	    
	    while ((len=fileIn.read(buffer))>0)
	        mClientHttpOut.write(buffer,len);        

		mClientHttpOut.flush();
		fileIn.close();
		// update lasAccessTime to reset timeout period
		if (server != null && sessionID != null)
			server.getSession().updateSession(sessionID, null);
	}

	public void sendRedirectResponse(String url) throws Exception{
		String data = "<HTML><BODY><SCRIPT>window.location.replace('" + url + "')</SCRIPT></BODY>/HTML>";
		String lastSite = null;
		HttpResponseHeader header = createResponseHeader(data.length());
	    mClientHttpOut.write(header);
		mClientHttpOut.write(new HttpBody(data));		
		mClientHttpOut.flush();
/*		
		int i;
		if ((i = url.indexOf("/"))!=-1)
			lastSite = url.substring(i+1);
*/			
		// update lasAccessTime to reset timeout period
		if (server != null && sessionID != null)
			server.getSession().updateSession(sessionID, null);
		
	}

	public void sendDataResponse(String data) throws Exception{
//		String data = "<HTML><BODY><SCRIPT>window.location.replace('" + url + "')</SCRIPT></BODY>/HTML>";
		String lastSite = null;
		HttpResponseHeader header = createResponseHeader(data.length());
	    mClientHttpOut.write(header);
		mClientHttpOut.write(new HttpBody(data));		
		mClientHttpOut.flush();

		// update lasAccessTime to reset timeout period
		if (server != null && sessionID != null)
			server.getSession().updateSession(sessionID, null);
		
	}


	public HttpResponseHeader createResponseHeader(int bodyLen){
		String data;
		String crlf = "\r\n";
	
		Format formatter = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss", Locale.ENGLISH);
//		DateFormat df = java.text.DateFormat.getDateInstance().format(new Date());
//		System.out.println(formatter.format(new Date()));
		
		data = "HTTP/1.0 200 OK" + crlf;
		data += "Date: " + formatter.format(new Date()) + " GMT"+ crlf;
		data += "Server: paros"+ crlf;
		if (isNewSession && sessionID != null){// && server.getSession().isSessionExisted(sessionID) ){
			data += "Set-cookie: "+ sessionID + crlf;
			isNewSession = false;
		}
		data += "Content-Length: "+ bodyLen+ crlf;
		data += "Content-Type: text/html"+ crlf;
		data += "Connection: Close"+ crlf+ crlf;

		HttpResponseHeader header = null;
		try{
			header = new HttpResponseHeader(data);
	        ((HttpHeader)header).setHeader("Cache-Control","no-cache"); //HTTP 1.1
    	    ((HttpHeader)header).setHeader("Pragma","no-cache"); //HTTP 1.0
	        ((HttpHeader)header).setHeader("Expires", "0"); //prevents caching at the proxy server

		}
		catch (HttpMalformedHeaderException e){
		}
		
		return header;
	}

	// not implemented
	private boolean validate(HttpRequestHeader header, HttpBody body){
		// no checks on null header field
//		sessionID = header.getHeader("Cookie");
		String path = header.getURIPathQuery();	
		if (path==null || path.equals("")){
			return false;
		}

		if (sessionID!= null && !sessionID.equals("") && !sessionID.matches("(\\d+)")){
			// check for valid session ID, only check if all are digits
			return false;
		}


		try{

			String realpath = AdminServer.DOCROOT + path;
			File dfile = new File(realpath);
	/*
			System.out.println(dfile.getAbsolutePath());
			System.out.println(dfile.getPath());
			System.out.println(dfile.getCanonicalPath());
			*/
			String canonicalPath = dfile.getCanonicalPath();
			
			if (!canonicalPath.equalsIgnoreCase(dfile.getAbsolutePath())){
				System.out.println("Path not canonical");
				return false;
				
			}
			// no '\\', '//' escape code checking
			if (!canonicalPath.toUpperCase().startsWith(AdminServer.DOCROOT.toUpperCase())){
//				System.out.println(AdminServer.DOCROOT);
				System.out.println("Path not under root directory");
				return false;				
			}
		}catch (IOException e){
			return false;
		}


		return true;
	}
	
	private void perform(String command, Hashtable param){
		
	}

	/*
	 *  this function now only handle the request for recorded response data
	 *  i.e. https://paros:8099/<Request ID>
	 */
	private void parse(HttpRequestHeader header, HttpBody body) throws Exception{
		String path = header.getURIPathQuery();	
		Pattern pattern = Pattern.compile("/(\\d+)");
		Matcher matcher = pattern.matcher(path);

		if (matcher.find()){
			// allow all images to be accessed without valid logon
			isNewSession = false;
			Vector result = Global.dumpAnalyzer.searchResponse(matcher.group(1)+ "." + Global.dumpLog.getCurDate());
			if (result!=null){
//				String lastSite = null;
//				String type = header.getHeader(HttpHeader.CONTENT_TYPE);
//				if (type==null || type.equals(""))
//					type = "text/html";
				String data = (String) result.get(1);
//				System.out.println(data.length());
//				data = data.substring(0,data.length()-2); //remove "\r\n"
				HttpResponseHeader header2 = new HttpResponseHeader((String)result.get(0));
				if (header2.getStatusCode()==301 || header2.getStatusCode()==302){
				// for redirect response, show the redirect body rather than redirected response
					header2 = createResponseHeader(data.length());
				}
				mClientHttpOut.write(header2);
				mClientHttpOut.write(new HttpBody(data));		
				mClientHttpOut.flush();

				// update lasAccessTime to reset timeout period
				if (server != null && sessionID != null)
					server.getSession().updateSession(sessionID, null);
				
				return;
			}
		}
	
		// all other cases reach here is unsuccessful
		sendError("No body content for this recorded response (" + path + ")" );
		
	}

	private void parse2(HttpRequestHeader header, HttpBody body) throws Exception{
		/*	not yet implemented functions
			1. validate logon if it is logon request. Then, Set-cookie in response
			2. validate session (check cookie) if want to access internal files		 		 
		 */

//		System.out.println(header.toString());

		String path = header.getURIPathQuery();	

		String realpath = AdminServer.DOCROOT + path;

		if (header.isImage()){
			// allow all images to be accessed without valid logon
			isNewSession = false;
			sendResponse(realpath);
	        return;
			
		}
		else if (header != null && header.getMethod().equals("POST") && path.equals("/logon")){
			if (logon(body)){
//				sendResponse(AdminServer.DOCROOT + File.separator + "main.htm"); //	redirect to menu.htm			
				sendRedirectResponse("/menu.htm");
			}
			else{
				sendRedirectResponse("/login.htm");
//				sendResponse(AdminServer.DOCROOT + File.separator + "main2.htm"); // redirect to login.htm				
//				sendResponse(AdminServer.DOCROOT + "/login.htm");
			}
			return;			
		}
		else if (path.equals("/logout")){			
			int status = server.getSession().getStatus(sessionID);
			if (status == Session.NOT_EXISTED){
				// note this may be a security hole for bruce-force attack
				sendError();
				return;	
		    }
		    else if (status == Session.EXPIRED){
				sessionID = "";
				isNewSession = true;  //reset client browser session cookie
				sendResponse(AdminServer.DOCROOT + File.separator + "expired.htm");		    
				return;	
		    }			
			logout();						
			sessionID = "";
			isNewSession = true;
			sendResponse(AdminServer.DOCROOT + File.separator + "logout.htm");
			return;

		}
		else if (path.equals("/view")){			
			int status = server.getSession().getStatus(sessionID);
			if (status == Session.NOT_EXISTED){
				// note this may be a security hole for bruce-force attack
				sendError();
				return;	
		    }
		    else if (status == Session.EXPIRED){
				sessionID = "";
				isNewSession = true;  //reset client browser session cookie
				sendResponse(AdminServer.DOCROOT + File.separator + "expired.htm");		    
				return;	
		    }			
			Hashtable param = parseParameter(body.toString());
			String pageindex;
			if ((pageindex = (String)param.get("pageindex"))!=null){		
//				System.out.println(pageindex);
				int index ;
				try{
					index = Integer.parseInt(pageindex);
				}
				catch(NumberFormatException fe){
					index = -1;
				}
				WebLink doc = (WebLink)Global.webDoc.getHistory(index);
//				if (doc == null)
//					System.out.println("no doc");
				if (mClientHttpOut == null)
					mClientHttpOut = new HttpOutputStream(mInSocket.getOutputStream());			

				if (doc != null && mClientHttpOut != null){
					// everything is ready now

//					System.out.println(doc.getRespHeader());
//					System.out.println(doc.getRespContent());
					HttpRequestHeader reqheader = (HttpRequestHeader)doc.getReqHeader();
					if (true){//reqheader.getMethod() == "GET"){
						// 
						String query = reqheader.getURIHostPathQuery();
//						System.out.println(query);

						int i;
						if ((i=query.indexOf("http://")) != -1)
							query = query.substring(i+7);
						if ((i = query.indexOf("https://")) != -1)
							query = query.substring(i+8);
//						System.out.println(query);
						sendRedirectResponse(query);						
					}
					else{
						// cannot handle POST now, not yet implemented	
					}
						/*
					if (doc.getRespHeader()!=null)
						mClientHttpOut.write(doc.getRespHeader());
					if (doc.getRespContent()!=null)
						mClientHttpOut.write(doc.getRespContent());
					mClientHttpOut.flush();
						*/
					
				}
				else{
					sendError();
					return;
				}
			}
		
			
			return;

		}
		else if (path.equals("/") || path.equals("/login.htm") ){
			if (sessionID != null){
				// clear session if login.htm is called by 'back' button
				server.getSession().removeSession(sessionID);
				sessionID = "";
				isNewSession = true;
			}
			String filename = AdminServer.DOCROOT + File.separator + "login.htm";
			sendResponse(filename);
			return;
	    }
		else{
			int status = server.getSession().getStatus(sessionID);
			if (status == Session.NOT_EXISTED){
				// note this may be a security hole for bruce-force attack
				sendError();
				return;	
		    }
		    else if (status == Session.EXPIRED){
				sessionID = "";
				isNewSession = true;  //reset client browser session cookie
				sendResponse(AdminServer.DOCROOT + File.separator + "expired.htm");		    
				return;	
		    }			

			if (path.equals("/cache")){			
				Hashtable param = parseParameter(body.toString());
				mnuCache(param);
				return;
			}
			else if (path.equals("/cache/status")){			
				Hashtable param = parseParameter(body.toString());
				mnuCacheFunction(param);
				return;
			}
			else if (path.equals("/cache/content")){			
				mnuCacheContent();
				return;
			}
			else
				sendResponse(realpath);
			return;				
		}


	}

	public void run() {

		try {
			mClientHttpIn = new HttpInputStream(mInSocket.getInputStream());
			mClientHttpOut = new HttpOutputStream(mInSocket.getOutputStream());			

			// validate IP against IP rules first
/*			
// moved to proxyhandler
			if (!isAccessAllowed(mInSocket)){
				sendError();
				disconnect();
				return;
			}
*/			
			mClientHttpInReqHeader = (HttpRequestHeader) mClientHttpIn.readHeader();
			mClientHttpInReqBody = mClientHttpIn.readBody();

//			assumeProxy();
//			afterRequestHeaderRead(mClientHttpInReqHeader);

			mHostName = mClientHttpInReqHeader.getHostName();
			mHostPort = mClientHttpInReqHeader.getHostPort();
			sessionID = mClientHttpInReqHeader.getHeader("Cookie");
			
			// All direct access (without authCode added by ProxyHandler) will be rejected by AdminServer
			if (mClientHttpInReqHeader.getHeader(server.getAuthCode())==null){// || !mClientHttpInReqHeader.getHeader(server.getAuthCode()).equals("paros")){
				sendError();
				disconnect();
				return;
			}
/*
			// validate content
			if (!validate(mClientHttpInReqHeader,mClientHttpInReqBody)){
				sendError();
				disconnect();
				return;
			}
*/
			// process request
			parse(mClientHttpInReqHeader,mClientHttpInReqBody);						

		} catch (HttpMalformedHeaderException e) {
			try {
				HttpResponseHeader errResponse = HttpResponseHeader.getError(HttpResponseHeader.HTTP_CLIENT_BAD_REQUEST);
				mClientHttpOut.write(errResponse);
				mClientHttpOut.flush();
			} catch (IOException ioe) {
			}

			showErrMessage("Malformed HTTP header from client.");

		} catch (IOException ioe) {
			showErrMessage("Error: " + ioe.getMessage() + ". connection closed");
//			ioe.printStackTrace();
		} catch (Exception e) {
			showErrMessage("Error: " + e.getMessage());
			e.printStackTrace();
		}
		
		//	place all final call, clean up here.
		disconnect();
/*
		if (count != 0) {
			counter.waitForTurn(count, 2000);
			counter.incrementTurn(count);
		}
*/
	}

	
	// not implemented
	private boolean logon(HttpBody body){
		// validation
		boolean valid = false;
		Hashtable param = parseParameter(body.toString());
		String name, pwd;
		if ((name = (String)param.get("textfield1"))!=null && (pwd = (String)param.get("textfield12"))!=null){		
			if (name.equals("admin") && pwd.equals("testing"))
				valid = true;
		
		}
		
		if (valid && server != null){
		// if valid, create session	
			sessionID = server.getSession().createSession();			
			isNewSession = true;
								
			return true;
		}
		else
			return false;
		
	}


	private boolean logout(){
		// not tested
		if (server != null && sessionID != null){
			if (server.getSession().getStatus(sessionID) == Session.EXISTED){
				server.getSession().removeSession(sessionID);
				return true;
			}
		}
		return false;
	}


	private Hashtable parseParameter(String param){
		
      int end = 0;
      int start = 0;
      int row =0, col=0;
	  String subStr;
	  String fieldname=null, value=null;
	  Hashtable table = new Hashtable();

	  try{	  
	      while (row<80 && (end=param.indexOf('=')) != -1){
	        // head
	        subStr = param.substring(start,end);
	        //myPostModel.setValueAt(URLDecoder.decode(subStr,"8859_1"),row,col);
	        fieldname = URLDecoder.decode(subStr,"8859_1");
//	        System.out.println(URLDecoder.decode(subStr,"8859_1") + " " + row + " " + col);
	        col++;
	        start=end+1;
	        param = param.substring(start,param.length());
          //System.out.println(fieldname + " " + param);
	        start=0;
	        if ((end=param.indexOf('&'))!=-1){
	          // value
	          subStr = param.substring(start,end);
	          value = URLDecoder.decode(subStr,"8859_1");
//	          System.out.println(fieldname + " " + value);
	//          myPostModel.setValueAt(URLDecoder.decode(subStr,"8859_1"),row,col);
  			  table.put(fieldname, value);
//		      System.out.println(URLDecoder.decode(subStr,"8859_1") + " " + row + " " + col);
	          row++;
	          col=0;
	          start=end+1;
	          param = param.substring(start,param.length());
	          start=0;
	        }
	        else{  // maybe last pair
	//            myPostModel.setValueAt(URLDecoder.decode(param,"8859_1"),row,col);
				  if (row==0)
				  	value = URLDecoder.decode(param,"8859_1");
				  else
		          	value = URLDecoder.decode(subStr,"8859_1");
		          table.put(fieldname, value);
//		          System.out.println(fieldname + " " + value);
//	 	      	System.out.println(URLDecoder.decode(subStr,"8859_1") + " " + row + " " + col);
	            return table;
	        }
	      }
	  }
	  catch(Exception e){
//	  	e.printStackTrace();
		System.out.println("Error: " + e.getMessage());
	  }
      return table;

	}
}


class Session {
	// one session for one application.  Don't create more than one session
	//static Hashtable table = new Hashtable();
	private static Hashtable table = new Hashtable();
	private static Random	staticRandomGenerator = 	new Random();
	public static int EXISTED = 1;
	public static int NOT_EXISTED = 0;
	public static int EXPIRED = -1;
	
	Session(){
/*		
		String test = createSession();
		System.out.println(test);
		String test2 = createSession();
		removeSession(test);
		updateSession(test);
		System.out.println(test+" " + test2);
*/
	}
	
	// call after successful logon
	public String createSession(){
		String s  = Long.toString(Math.abs(staticRandomGenerator.nextLong())) + Long.toString(Math.abs(staticRandomGenerator.nextLong()));
//		Long setTime = new Long(System.currentTimeMillis());
		SessionObject obj = new SessionObject();
		obj.lastTime = new Long(System.currentTimeMillis());
		table.put(s,obj);
//		System.out.println(s + " " + table.get(s));
		return s;
	}
/*
	public boolean isSessionExpired(String s){
		if (s == null || s.equals(""))
			return false;
			
	    Long n = (Long)table.get(s);
	    if (n!= null && System.currentTimeMillis() - n.longValue() > 1200000){ // 20 min timeout
	    	return true;
	    }
	    else
	    	return false;
	}
*/
	public int getStatus(String s){
		Long n;
		if (s == null || s.equals(""))
			return NOT_EXISTED;

		SessionObject obj = (SessionObject)table.get(s);			
		if (obj != null){
	    	n = obj.lastTime;
	    }
	    else
	    	return NOT_EXISTED;
	    	
	    if (n!= null && System.currentTimeMillis() - n.longValue() > 1200000){ // 20 min timeout
	    	removeSession(s);
	    	return EXPIRED;
	    }
	    if (n != null) {
	        //System.out.println("two = " + n);
	        return EXISTED;
	    }
	    else
	    	return NOT_EXISTED;
	}


/*
	public boolean isSessionExisted(String s){
		if (s == null || s.equals(""))
			return false;
			
	    Long n = (Long)table.get(s);
	    if (n!= null && System.currentTimeMillis() - n.longValue() > 1200000){ // 20 min timeout
	    	removeSession(s);
	    	n = null;
	    }
	    if (n != null) {
	        //System.out.println("two = " + n);
	        return true;
	    }
	    else
	    	return false;
	}
*/
	public void updateSession(String s, String lastVisitedSite){
		if (s!=null && getStatus(s) == EXISTED){			
//			Long setTime = new Long(System.currentTimeMillis());
			SessionObject obj = new SessionObject();
			obj.lastTime = new Long(System.currentTimeMillis());
			obj.lastSite = lastVisitedSite;
			table.put(s,obj);
		}
//		System.out.println(s + " " + table.get(s));
	}

	public String getLastSite(String s){
		SessionObject obj = (SessionObject)table.get(s);
		if (obj != null)
	    	return obj.lastSite;
	    else	
	    	return null;
	}
	
	public void removeSession(String s){
		table.remove(s);
//		System.out.println(s + " " + table.get(s));

	}

	class SessionObject{
		private Long lastTime = null;
		private String lastSite = null;
		SessionObject(){
		}	
	}
	
}

