/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros;

import java.util.Enumeration;
import java.util.Vector;

import com.proofsecure.paros.filter.*;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;

public class FilterManager extends FunctionManager{ //extends Thread implements HeaderFilter{
 // used for dynamic loading of filters	
 protected final String path = ".//paros//filter//"; 
 protected final String cpath = "paros.filter."; 
 protected final String classtype = ".class"; 	

  

 public void createList(){
      Enumeration v = this.getNames();

      while (v.hasMoreElements()) {
        String name = (String)v.nextElement();
//        System.out.println(name);
        Vector row = new Vector();
        if (name.equals("LogCookie"))
        	row.add(new Boolean(true));  
        else
        	row.add(new Boolean(false));  //set to false for startup
        row.add(((AbstractFilter)items.get(name)).getDialog());  //set to false for first time
//        row.add(name);
        row.add(((AbstractFilter)items.get(name)).usage());
        enablelist.add(row);
           
       }

 }
 


  /**
      init the ScanManager, which is called once (static) in ProxyHandler
      @param  
      @return
  */
  protected void init(){      
  
	items.put("ReplaceResponseBody", new ReplaceResponseBody());   
	items.put("ReplaceResponseHeader", new ReplaceResponseHeader());   
	items.put("ReplaceRequestBody", new ReplaceRequestBody());   
	items.put("ReplaceRequestHeader", new ReplaceRequestHeader());   
    items.put("CookieDetectFilter", new CookieDetectFilter());  
    items.put("LogPostQuery", new LogPostQuery());  
    items.put("LogGetQuery", new LogGetQuery());   
    items.put("LogCookie", new LogCookie());
    items.put("DetectUnsafeContent", new DetectUnsafeContent());   
    items.put("IfModifiedSinceFilter", new IfModifiedSinceFilter());  
    
  //  initDynamic(path, cpath, classtype);
  }

  public void clearFilterStatus(String s){
  	AbstractFilter filter = (AbstractFilter)items.get(s);
  	if (filter!=null)
  		filter.clearInternalStatus();
  }

  /**
      Called by proxyHandler to filter each HTTP request/response headers
      @param  header  header to be filtered
      @param  body		body to be filtered
  */
    public void filterRequest(HttpRequestHeader reqHeader, HttpBody body){
      AbstractFilter filter;

      if (items.size() < 1)   // no filters
        return;
      
      int i=0;  
      for (Enumeration e = items.elements() ; e.hasMoreElements() ;) {
          filter  = (AbstractFilter) e.nextElement() ;
          if ( ((Boolean)(((Vector)(enablelist.elementAt(i))).elementAt(0))).booleanValue() )
            filter.filterRequest(reqHeader, body);        
          i++;
      } 
    }
    
    public void filterResponse(HttpRequestHeader reqHeader, HttpResponseHeader resHeader, HttpBody body){
    	AbstractFilter filter;

    	if (items.size() < 1)   // no filters
    		return;
    	
    	int i=0;  
    	for (Enumeration e = items.elements() ; e.hasMoreElements() ;) {
    		filter = (AbstractFilter) e.nextElement() ;
    		if ( ((Boolean)(((Vector)(enablelist.elementAt(i))).elementAt(0))).booleanValue() )
    			filter.filterResponse(reqHeader, resHeader, body);        
    		i++;
    	} 
    }
    
  


  /**
      check if the filter has interface HeaderFilter
      @param  cls   class of the filter
      @return yes or no
   */
  protected boolean isFilter(Class cls){
    Class[] intfs = cls.getInterfaces();
    for (int i=0; i<intfs.length; i++) {    
      if (intfs[i].getName().equals(cpath + "Filter"))
        return true;
    }
    return false;
  }

/*
  public void setEnabled(String filtername, boolean value){
//      System.out.println(filtername + " " + value);
//    items.get(filtername).setEnabled(false);
//    enabled
  }
*/
  
}



 
