/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros;
 
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;

import com.proofsecure.paros.network.HttpConnection;
import com.proofsecure.paros.network.HttpConnectionPool;
import com.proofsecure.paros.util.Util;

class ProxyPortForwardHandler extends ProxyHandler {


	ProxyPortForwardHandler() {
		super();
	}

	/**
	Main process method in Run()
	*/
	protected void process() {
		processForward(Global.cmdHostName, Global.cmdHostPort);
	}

	/**
	Handler for pass through
	*/
	private void processForward(String hostName, int hostPort) {

		int len = 0;
		byte[] buf = new byte[BUFFEREDSTREAM_SIZE];
		long lastTime = 0;
		BufferedInputStream	proxy_in = null;
		BufferedOutputStream proxy_out = null;
		BufferedOutputStream passthru_out = null;
		BufferedInputStream passthru_in = null;
		HttpConnectionPool pool = new HttpConnectionPool(Global.config, Global.ssl);
		HttpConnection conn = null;
		boolean isRespondedOnce = false;
				
		try {
			proxy_in = new BufferedInputStream(mInSocket.getInputStream(), BUFFEREDSTREAM_SIZE);
			proxy_out = new BufferedOutputStream(mInSocket.getOutputStream());

			
			//conn = pool.connect(hostName, hostPort, isSecure, false);
			mOutSocket = Util.connect(hostName, hostPort, false);
			passthru_out = new BufferedOutputStream(mOutSocket.getOutputStream());
			passthru_in = new BufferedInputStream(mOutSocket.getInputStream(), BUFFEREDSTREAM_SIZE);

			do {

				// restrict reading count to give chance to read output
				
				for (int i=0; i<3 && proxy_in.available() > 0;i++) {
					len = proxy_in.read(buf);
					if (len > 0) {
						passthru_out.write(buf,0,len);
						passthru_out.flush();
						lastTime = System.currentTimeMillis();
					}
				}

				// switch to other thread as request just sent
				Thread.yield();
				
				for (int i=0; i<3 && passthru_in.available() > 0;i++) {
					len = passthru_in.read(buf);
					if (len > 0) {
						proxy_out.write(buf,0,len);
						proxy_out.flush();
						isRespondedOnce = true;
						System.out.print(".");
						lastTime = System.currentTimeMillis();
					}
				}

				if (proxy_in.available() > 0 || passthru_in.available() > 0) {
					continue;
				}
				
				Util.sleep(20);

				if (isRespondedOnce) {
					if (System.currentTimeMillis() > lastTime + 4000) {
						break;
					}
				} else {
					if (System.currentTimeMillis() > lastTime + 30000) {
						break;
					}
				}
					

			} while (!mInSocket.isClosed() && !mOutSocket.isClosed()
					&& !mOutSocket.isInputShutdown() && !mInSocket.isInputShutdown() );

		} catch (Exception e) {
			//e.printStackTrace();
		}

		Util.closeInputStream(proxy_in);
		Util.closeOutputStream(proxy_out);
		Util.closeInputStream(passthru_in);
		Util.closeOutputStream(passthru_out);

		pool.close();
	}


}



