/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.filter;

import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpRequestHeader;

/* remove all 'If-Modified-Since' header line
 * 
 *
 */
public class IfModifiedSinceFilter extends AbstractFilter {
    
  public IfModifiedSinceFilter(){
  	dialog = new PDialog("IfModifiedSinceFilter");
  	
  }

  
  /**
   *   used by FilterManager to run the filter 
   *   @param    reqHeader	Request Header
   *   @param	resBody		Response body to be filtered
   */
  public void filterRequest(HttpRequestHeader reqHeader, HttpBody reqBody) {
  	if (reqHeader != null && reqHeader.isText()){
  		String ifModifed = reqHeader.getHeader("If-Modified-Since");
  		if (ifModifed != null){    
  			reqHeader.setHeader("If-Modified-Since", null);                   
  		}
  		String ifNoneMatch = reqHeader.getHeader("If-None-Match");
  		if (ifNoneMatch != null){    
  			reqHeader.setHeader("If-None-Match", null);                   
  		}
  		
  	}
  }
  
  
  public String usage(){
    return "Remove 'If-Modified-Since' & 'If-None-Match' header fields in HTTP request.";
  }    
  
}
