/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.regex.Pattern;

/**
 *
 */
public class Dump {
	
	public static String REQUEST_FILE = "request.log";
	public static String RESPONSE_FILE = "response.log";
	public static String INDEX_FILE = "index.txt";

	private long curDate = System.currentTimeMillis();//Calendar.getInstance().getTimeInMillis();
	public static String PROJECT_DIR = "project";
	private String dumpPrefix = "session";
	public static String SEPARATOR_LEFT = "<!--//=============== ";
	public static String SEPARATOR_RIGHT = " ===============//-->";
	/**
	 * 
	 */
	public Dump() {
		checkFileSize();
	}

	public Dump(String name, boolean renameLargeFile, boolean overwrite) {
		dumpPrefix = name;	
		
		if (renameLargeFile)
			checkFileSize();
		
		if (overwrite){
			deleteOldFile();
		}
		
	}


	private void deleteOldFile(){
		File reqFile = getFile(REQUEST_FILE);
		File resFile = getFile(RESPONSE_FILE);
		File idxFile = getFile(INDEX_FILE);
		idxFile.delete();
		reqFile.delete();
		resFile.delete();
	}
	
	/*
	 * check the size of the old dump file.  If it's too large (>6M bytes), rename it.
	 * This can reduce the response time of searching in Dump/Log Viewer
	 */
	private void checkFileSize(){
		File reqFile = getFile(REQUEST_FILE);
		File resFile = getFile(RESPONSE_FILE);
		File idxFile = getFile(INDEX_FILE);
		long length, length2;
		length = reqFile.length();
		length2 = resFile.length();
//		System.out.println(length + ":" + length2);
		if (length > 6000000 || length2 > 6000000){  // rename if larger than 6M bytes
			String curDir = System.getProperty("user.dir") + File.separator + PROJECT_DIR;
			long curTime = System.currentTimeMillis();
			String path = curDir + File.separator + dumpPrefix + "_"  + curTime + "_" ;
			String curFile = path + REQUEST_FILE;
			File rFile = new File(curFile);
			boolean success = reqFile.renameTo(rFile);
			if (!success) {
				// File was not successfully renamed
				System.out.println("Can't rename old dump files.");
				return;
			}

			curFile = path  + RESPONSE_FILE;
			rFile = new File(curFile);
			success = resFile.renameTo(rFile);
			if (!success) {
				// File was not successfully renamed
				System.out.println("Can't rename old dump files.");
				return;
			}

			curFile = path  + INDEX_FILE;
			rFile = new File(curFile);
			success = idxFile.renameTo(rFile);
			if (!success) {
				// File was not successfully renamed
				System.out.println("Can't rename old dump files.");
				return;
			}
			else
				System.out.println("Renamed old dump files.");
		}
	}

	private String getCurDir(){
		return System.getProperty("user.dir") + File.separator + PROJECT_DIR;
	}

	public File getFile(String s) {
		String curDir =
			System.getProperty("user.dir") + File.separator + PROJECT_DIR;
		String curFile = curDir + File.separator + dumpPrefix + "_"  + s;

		File dir = new File(curDir);
		if (!dir.exists()) {
			dir.mkdir();
		}
		File f = new File(curFile);
		return f;
	}

	// get the path String 
	public String getFilePath(String s) {
		File f = getFile(s);
		return f.getPath();
	}

	public synchronized void log(String logName, int id, String req, String res) {
		File logFile = getFile(logName);
		String separator = "\t";
		String index = logName.substring(0,3) + separator + id + "." + curDate ;
		/*
				try {
					BufferedWriter out = new BufferedWriter(new FileWriter(logFile,true));
					out.write("\r\n" + LINE_SEPARATOR + curDate + "-" + id + LINE_SEPARATOR + "\r\n");
					out.write(s);
					out.close();
				} catch (IOException e) {
					System.out.println(e.getMessage());
				}
		*/
		try {
			// Create a writable file channel
			FileChannel out = new FileOutputStream(logFile, true).getChannel();
			if(id > -1){
				index += separator + out.size(); 
				out.write(ByteBuffer.wrap(getHeaderLine(id)));
				index += separator + out.position();
				out.write(ByteBuffer.wrap(req.getBytes("8859_1")));
				index += separator + out.position();
				if (res != null)
					out.write(ByteBuffer.wrap(res.getBytes("8859_1")));
				index += separator + out.position();
			}			
			out.close();
			
			index += "\r\n";
			out = new FileOutputStream(getFile(INDEX_FILE), true).getChannel();
			out.write(ByteBuffer.wrap(index.getBytes()));
			out.close();
			
		} catch (IOException e) {
			System.out.println("Error writing log: " + e.getMessage());
		}

	}

	private byte[] getHeaderLine(int id){
		return (
		"\r\n"
		+ SEPARATOR_LEFT
		+ System.currentTimeMillis()
		+ "-"
		+ id
		+ "."
		+ curDate
		+ SEPARATOR_RIGHT
		+ "\r\n")
		.getBytes();
	}

	public Pattern getCurrentHeaderPattern(){
		return Pattern.compile(Dump.SEPARATOR_LEFT
		+ "\\d+[-]((\\d+)[.]"
		+ "("
		+ curDate 
		+ ")"
		+ ")"
		+ Dump.SEPARATOR_RIGHT);
	}

	public Pattern getHeaderPattern(String timestamp){
		return Pattern.compile(Dump.SEPARATOR_LEFT
		+ "\\d+[-]((\\d+)[.]"
		+ "(" 
		+ timestamp
		+ ")"
		+ ")"
		+ Dump.SEPARATOR_RIGHT);
	}
	/**
	 * @return
	 */
	public String getDumpPrefix() {
		return dumpPrefix;
	}

	/**
	 * @return
	 */
	public String getPROJECT_DIR() {
		return PROJECT_DIR;
	}

	/**
	 * @param string
	 */
	public void setPROJECT_DIR(String string) {
		PROJECT_DIR = string;
	}


	/**
	 * @return
	 */
	public long getCurDate() {
		return curDate;
	}

	public void resetCurDate() {
		curDate = System.currentTimeMillis();
	}
	/**
	 * @param string
	 */
	public void setDumpPrefix(String string) {
		dumpPrefix = string;
	}

}
