/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.log;

import java.util.regex.Pattern;


/**
 * 
 * TODO Tasks to be done
 * - support viewing other logs from scanner and spider
 * - allow viewing the whole log file or current session only
 * - allow searching/filtering
 *  
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */

public class DumpAnalyzerGUI extends DumpAnalyzer {
	private DumpFrame dFrame;

	public DumpAnalyzerGUI(Dump d) {
		super(d);
		dFrame = new DumpFrame(this, model);
		//		dFrame.setListModel(model);
	}

	public void setTitle(String s){
		dFrame.setTitle(DumpFrame.FRAME_NAME + " - " + s);
	}
	public void show() {
		refresh();
		dFrame.showGUI();
	}

	public void refresh() {
		if (openFile())
			readList(Pattern.compile(""), "request");
	}

	public void refresh(Pattern pattern, String searchPlace) {
		if (openFile()){
			if (pattern.equals(""))
				refresh();  // no search, reset and show all
			else
				readList(pattern, searchPlace);
		}
	}



/*
	public static void main(String[] args) {
		DumpAnalyzerGUI da = new DumpAnalyzerGUI(new Dump());
		//		da.show();
		BufferedReader feed;
		if ((feed = da.openResponseFeed()) != null) {
			ScannerOffline scanner = new ScannerOffline();
			scanner.test(feed);
		}

	}
*/
}
