/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.network;


public class HttpBody implements java.io.Serializable{

	private StringBuffer body = new StringBuffer();

	public HttpBody() {
	}


	public HttpBody(String data) {
		body.append(data);
	}

	public void setBody(String data) {
		body.setLength(0);
		body.append(data);
	}

	public void append(byte[] buf, int len) {
		String temp = null;
		try {
			temp = new String(buf, 0, len, "8859_1");
		} catch (Exception e) {
			temp = new String(buf, 0, len);
		}
		body.append(temp);
	}

	public void append(String buf) {
		body.append(buf);
	}

	public String toString() {
		return body.toString();
	}

	public int length() {
		return body.length();
	}

	public void setLength(int length) {
		body.setLength(length);
	}
}