/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.network;
 
import java.io.IOException;
import java.net.Socket;

public class HttpConnection {
	
	public	String				mHostName= "";
	public	int 				mPort = 80;
	public	boolean				mIsSecure = false;
	public	HttpInputStream		mHttpIn = null;
	public	HttpOutputStream 	mHttpOut = null;
	public	Socket				mSocket = null;
	public	HttpConnectionPool	mPool = null;
	private boolean				mIsClosed = false;
		
	HttpConnection(String hostName, int port, boolean isSecure, Socket socket, HttpConnectionPool pool) throws IOException {
		mHostName = hostName;
		mPort = port;
		mIsSecure = isSecure;
		mPool = pool;
		setSocket(socket);
	}
	
	void setSocket(Socket socket) throws IOException {
		mSocket = socket;
		mHttpIn = new HttpInputStream(this, mPool);
		mHttpOut = new HttpOutputStream(this, mPool);
		mIsClosed = mSocket.isClosed();
	}
	
	public void close() {
		mIsClosed = true;
		mHttpIn.close();
		mHttpOut.close();
		HttpUtil.close(mSocket);
	}
	
	public boolean isClosed() {
		if (!mIsClosed) {
			mIsClosed = mSocket.isClosed();
		}
		return mIsClosed;
	}
	

}