/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.network;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public class HttpOutputStream {

	private static final String CODEPAGE = "8859_1";
	private static final String CRLF2 = "\r\n\r\n";
	private static final String LF2 = "\n\n";
	//private OutputStream out = null;
	private BufferedOutputStream out = null;
	private long mLastActiveTime = System.currentTimeMillis();
	private LastActiveAdapter mLastActiveAdapter = null;
	private Socket mSocket = null;
	private boolean mCloseConnection = true;
	
	public HttpOutputStream(OutputStream out) {
		//this.out = out;
		//this.out = new BufferedOutputStream(out, 4096);
		this.out = new BufferedOutputStream(out);

	}
	
	public HttpOutputStream(HttpConnection conn, LastActiveAdapter lastActiveAdapter) throws IOException {
		this(conn.mSocket.getOutputStream());
		mSocket = conn.mSocket;
		mLastActiveAdapter = lastActiveAdapter;
	}

	public void write(HttpHeader header) throws IOException {
		String tmp = header.toString();
		out.write(tmp.getBytes(CODEPAGE));
		flush();
		setLastActive();
		processAfterWriteHeader(header);
	}

	public void write(HttpBody body) throws IOException {

		byte[] buf = body.toString().getBytes(CODEPAGE);
		write(buf);
		processAfterWriteBody();
	}

	public void write(byte[] buf) throws IOException {
		write(buf, 0, buf.length);
	}

	public void write(byte[] buf, int len) throws IOException {
		write(buf, 0, len);
	}
	
	public void write(byte[] buf, int off, int len) throws IOException {
		if (len > 0) {
			setLastActive();
			out.write(buf, off, len);
			flush();
		}
	}

	public void close() {
		try {
			out.close();
		} catch (Exception e) {
		}
		HttpUtil.close(mSocket);
	}

	public void flush() throws IOException {
		out.flush();
	}

	long lastActiveTimeMillis() {
		return mLastActiveTime;
	}
	
	/**
	Set last active state.  Should be placed before write as write may take longer time to completed.
	*/
	private void setLastActive() {
		mLastActiveTime = System.currentTimeMillis();
		if (mLastActiveAdapter != null) {
			mLastActiveAdapter.setLastActive();
		}
	}
	
	private void processAfterWriteHeader(HttpHeader header) {
		mCloseConnection = header.isConnectionClose();
	}

	private void processAfterWriteBody() {
		if (mCloseConnection) {
		//	close();
		}
	}
					
}