/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import com.proofsecure.paros.util.ThreadPool;
import com.proofsecure.paros.Global;

abstract public class AbstractAppTest extends AbstractTest implements Runnable {




	/**
	Not to be directly created by others.
	*/
	protected AbstractAppTest() {
	}

	/**
	Abstract method to start a test.
	*/
	void startTest(ParsedEntity startEntity) {
		mThreadPool = new ThreadPool(Global.scanner.getScannerThread());
		scanTree(startEntity);
		mThreadPool.waitAllThreadComplete(WAIT_TIME_MILLIS);
	}

	
	/**
	In-order traverse nodes and children and run a specified scan.
	*/
	protected void scanTree(ParsedEntity entity) {

		if (isSignalStop()) {
			return;
		}

		scanOneNode(entity);

		// give time to pause
		/*
		try {
			Thread.sleep(50);
		} catch (Exception e) {
		}
		*/

		for (int i=0; i<entity.getChildCount(); i++) {
			try {
				scanTree((ParsedEntity) entity.getChildAt(i));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

	}

	/**
	Scan the supplied node only with the specified scan.
	*/
	protected void scanOneNode(ParsedEntity entity) {

		// if exit, no more scan
		if (isSignalStop()) {
			return;
		}

		
		// skip if session node
		if (entity.isRoot()) {
			return;
		}
		
		
		AbstractTest test = null;
		try {
			test = create();
			test.init(entity);
			Thread t = mThreadPool.getFreeThread(test);
			t.start();

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	Clone this test for running in multiple threads.
	*/
	public AbstractAppTest create() {
		AbstractAppTest test = null;
		try {
			test = (AbstractAppTest) this.getClass().newInstance();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return test;
	}
	


}
