/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import java.util.Vector;

import com.proofsecure.paros.util.ThreadPool;
import com.proofsecure.paros.Global;

abstract class AbstractServerTest extends AbstractTest {


	protected AbstractServerTest() {
	}

	void startTest(ParsedEntity entity) {
		mThreadPool = new ThreadPool(Global.scanner.getScannerThread());
		mTestCase = new Vector();
		
		if (entity.isRoot()) {
			for (int i=0; i<entity.getChildCount();i++) {
				try {
					ParsedEntity child = (ParsedEntity) entity.getChildAt(i);
					init(child);
					scanServer(child);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		} else {
	
			try {
				init(entity);
				scanServer(entity);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		mThreadPool.waitAllThreadComplete(WAIT_TIME_MILLIS);
	}
	

	protected void scanServer(ParsedEntity entity) {
		
		// stop gracefully if stop scan
		if (isSignalStop()) {
			return;
		}
		
		try {
			ParsedEntity parent = (ParsedEntity) entity.getParent();
			if (parent != null && parent.isRoot()) {
				scanNode(entity);
			} else {
				for (int i=0; i<entity.getChildCount(); i++) {
					try {
						scanServer((ParsedEntity) entity.getChildAt(i));
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	Scan the supplied node only with the specified scan.
	*/
	protected void scanNode(ParsedEntity entity) {
		// skip if session node
		if (entity.isRoot()) {
			return;
		}

		AbstractServerTest test = null;

		// stop gracefully if stop scan
		while (mTestCase.size() > 0 && !isSignalStop()) {
			try {
				test = getAndRemoveTestCase();
				Thread t = mThreadPool.getFreeThread(test);
				t.start();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	private Vector mTestCase = null;
	
	protected void addTestCase(AbstractServerTest test) {
		synchronized (mTestCase) {
			mTestCase.add(test);
		}
	}
	
	protected AbstractServerTest getAndRemoveTestCase() {
		AbstractServerTest test = null;
		synchronized (mTestCase) {
			if (mTestCase.size() > 0) {
				test = (AbstractServerTest) mTestCase.elementAt(0);
				mTestCase.removeElementAt(0);
			}
		}
		return test;
	}






}