/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.scan;

import java.io.IOException;
import java.util.Hashtable;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AlertDB {

	// constants
	private static final String		ALERTITEM				= "alertitem";
	private static final String		ID						= "id";
	private static final String		ALERT					= "alert";
	private static final String		DESC					= "desc";
	private static final String		SOLUTION				= "solution";
	private static final String		REFERENCE				= "reference";
	
    private static final String[]	PATH_ID		 			= {ALERTITEM, ID};
    private static final String[]	PATH_ALERT				= {ALERTITEM, ALERT};
    private static final String[]	PATH_DESC				= {ALERTITEM, DESC};
	private static final String[]	PATH_SOLUTION			= {ALERTITEM, SOLUTION};
	private static final String[]	PATH_REFERENCE			= {ALERTITEM, REFERENCE};
	
	// xml document processing
	private Document				mDoc		= null;
	private DocumentBuilderFactory	mFactory 	= null;
	private DocumentBuilder 		mBuilder	= null;

	private Hashtable	mAlertTable	= new Hashtable();
	
	public AlertDB() {
		try {
			mFactory = DocumentBuilderFactory.newInstance();
			mFactory.setValidating(false);
			mBuilder	= mFactory.newDocumentBuilder();
			//builder.setErrorHandler(new ErrorHandler() {
			//});
		} catch (ParserConfigurationException e) {
		}
	}
	
	public void read(String fileName) throws SAXException, IOException {
		
		mDoc = mBuilder.parse(fileName);
		processAlert();
	}
	
	public void processAlert() {
		NodeList nodes = mDoc.getElementsByTagName(ALERTITEM);
		Element ele = null;
		AlertItem item = null;
		String tmp = null;
		int id = 0;
		for (int i=0; i<nodes.getLength(); i++) {
			tmp = getText(getElement(nodes, i, PATH_ID));
			try {
				id = Integer.parseInt(tmp);
				item = new AlertItem(id);

				tmp = getText(getElement(nodes, i, PATH_ALERT));
				item.setAlert(tmp);

				tmp = getText(getElement(nodes, i, PATH_DESC));
				item.setDesc(tmp);

				tmp = getText(getElement(nodes, i, PATH_SOLUTION));
				item.setSolution(tmp);

				tmp = getText(getElement(nodes, i, PATH_REFERENCE));
				item.setReference(tmp);

				mAlertTable.put(new Integer(id), item);
			} catch (NumberFormatException e) {
			}
		}
	}
	
	public void main(String[] args) {
		try {
			AlertDB db = new AlertDB();
			db.read(args[0]);
		} catch (SAXParseException e) {
			e.printStackTrace();
			System.out.println(e.getMessage() + " Line=" + e.getLineNumber() + e.getPublicId());
		} catch (SAXException e) {
		} catch (IOException e) {
		}

		/*
		System.out.println("IP = " + getProxyIP());
		System.out.println("Port = " + getProxyPort());
		System.out.println("SSL = " + getProxyPortSSL());
		System.out.println("Use chain = " + isUseProxyChain());
		System.out.println("Chain IP = " + getProxyChainName());
		System.out.println("Chain IP = " + getProxyChainPort());

		System.out.println("Skip = " + isSkipProxyChain(args[1]));
		*/
    }

	private Element getElement(NodeList nodes, int num, String[] path) {
		Element ele = (Element) nodes.item(num);
		for (int i=1; i<path.length; i++) {
			nodes = ele.getElementsByTagName(path[i]);
			ele = (Element) nodes.item(0);
		}
		return ele;
	}


			
	/**
	Get the text in text node from the element.
	@param	element	Element to get text from
	@return	Text in the text node under the element
	*/
	private String getText(Element element) {
		if (element == null) {
			return "";
		}
		
		for (int i=0; i<element.getChildNodes().getLength(); i++) {
			Node node = element.getChildNodes().item(i);
			if (node.getNodeType() == Node.TEXT_NODE) {
				return node.getNodeValue();
			}
		}
		return "";
	}
	
	/**
	Set the text in text node of a element.
	@param	element	Element to be set
	@param	text	Text to be set
	*/
	private void setText(Element element, String text) {
		for (int i=0; i<element.getChildNodes().getLength(); i++) {
			Node node = element.getChildNodes().item(i);
			if (node.getNodeType() == Node.TEXT_NODE) {
				node.setNodeValue(text);
				return;
			}
		}
	}
    
    /**
    Return the alert item of a certain ID
    */
    public AlertItem get(int id) {
		AlertItem result = null;
		try {
			result = (AlertItem) mAlertTable.get(new Integer(id));
		} catch (NullPointerException e) {
			result = new AlertItem(0);
			result.setAlert("Alert not found");
		}
		return result;
	}    			
	
	/**
	Get a new instance of alert item with alert filled.
	*/	
	public AlertItem getInstance(int id) {
		AlertItem result = get(id).newInstance();
		return result;
	}
	
	/**
	Return the hashtable.
	*/
	Hashtable getTable() {
		return mAlertTable;
	}
		
}

