/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import com.proofsecure.paros.Global;

public class Scanner extends AbstractScanner {

	public Scanner() throws Exception {
		super();
	}

	protected void process() throws Exception {
		mAnalyser = new Analyser();
		mAnalyser.startTest(mStartEntity);

		Object test = null;
		Hashtable testlist = Global.scanManager.getHashtable();
		Vector enablelist = Global.scanManager.getDataModel();

        int i=0;
	    for (Enumeration e = testlist.elements() ; e.hasMoreElements() && !mIsSignalStop;) {
	        test = e.nextElement();
	        if ( ((Boolean)(((Vector)(enablelist.elementAt(i))).elementAt(0))).booleanValue() ){
	        	if (test instanceof AbstractTest){
	          		mTestModel = (AbstractTest)test;
					writeOutput("Testing " + mTestModel.getTestName() + "...");
					mTestModel.startTest(mStartEntity);
	          	}    	          	       
				
	        }
	        i++;
	    }
	    
	    if (mTestModel != null) {
			mTestModel.getThreadPool().waitAllThreadComplete(30000);
		}


	}
	
	protected void endOfProcess() {
		generateAlertReport();
	}


			

}
