/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.proofsecure.paros.network.HttpStatusCode;

class TestDirBrowse extends AbstractAppTest {

	private final static Pattern patternIIS			= Pattern.compile("Parent Directory", PATTERN_PARAM);
	private final static Pattern patternApache		= Pattern.compile("\\bDirectory Listing\\b.*(Tomcat|Apache)", PATTERN_PARAM);
	
	// general match for directory
	private final static Pattern patternGeneralDir1		= Pattern.compile("\\bDirectory\\b", PATTERN_PARAM);
	private final static Pattern patternGeneralDir2		= Pattern.compile("[\\s<]+IMG\\s*=", PATTERN_PARAM);
	private final static Pattern patternGeneralParent	= Pattern.compile("Parent directory", PATTERN_PARAM);

	TestDirBrowse() {
	}

    public String toString() {
        return "TestDirBrowse";
    }

	public String getTestName() {
		return "Directory Browsing";
	}

	private void buildHeader() {
		URI uri = getEntity().getURIHostPath();
		String sUri = uri.toString();
		if (!sUri.endsWith("/")) {
			sUri = sUri + "/";
		}
		getRequestHeader().setURI(sUri);
	
	}

	protected void scan() throws Exception {
		boolean result		= false;
		buildHeader();

		//writeOutput("DirBrowse: " + getRequestHeader().getURIHostPath());
		writeStatus("DirBrowse: " + getRequestHeader().getURIHostPath());

		sendAndReceive();

		if (getResponseHeader().getStatusCode() != HttpStatusCode.OK) {
			return;
		}

		Matcher matcher = null;
		int reliability = AlertItem.WARNING;
		if (matchBodyPattern(patternIIS, null)) {
			result = true;
		} else if (matchBodyPattern(patternApache, null)) {
			result = true;
		} else if (matchBodyPattern(patternGeneralParent, null)) {
			result = true;
			reliability = AlertItem.SUSPICIOUS;
		} else if (matchBodyPattern(patternGeneralDir1, null)) {
			if (matchBodyPattern(patternGeneralDir2, null)) {
				result = true;
				reliability = AlertItem.SUSPICIOUS;
			}
		}
		
		if (result) {
			bingo(10001, AlertItem.RISK_MEDIUM, reliability, "", "", "");
		}

	}
	



}