/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.proofsecure.paros.network.HttpRequestHeader;

class TestHttpMethod extends AbstractAppTest {

	private static Pattern staticPatternPUT = Pattern.compile("\\bPUT\\b", PATTERN_PARAM);
	private static Pattern staticPatternDELETE = Pattern.compile("\\bDELETE\\b", PATTERN_PARAM);

	TestHttpMethod() {
	}

    public String toString() {
        return "TestHttpMethod";
    }
    
	public String getTestName() {
		return "Http Methods (PUT, DELETE and WebDAV)";
	}

	private void buildHeader() {
		String result = getEntity().getURIHostPath().toString();
		getRequestHeader().setURI(getEntity().getURIHostPath().toString());
		getRequestHeader().setMethod(HttpRequestHeader.OPTIONS);

	}

	protected void scan() throws Exception {
		Matcher matcher = null;
		StringBuffer sb = new StringBuffer();
		String param = null;
		
		buildHeader();
		writeStatus("HttpMethods: " + getRequestHeader().getURIHostPath());
		sendAndReceive();
		
		param = getResponseHeader().getHeader("Allow");
		if (param == null) {
			return;
		}

		matcher = staticPatternPUT.matcher(param);
		if (matcher.find()) {
			sb.append("PUT");
		}

		matcher = staticPatternDELETE.matcher(param);
		if (matcher.find()) {
			if (sb.length() > 0) {
				sb.append(", ");
			}
			sb.append("DELETE");
		}

		param = getResponseHeader().getHeader("DAV");
		if (param != null) {
			if (sb.length() > 0) {
				sb.append(", ");
			}
			sb.append("WebDAV");
		}	
		
		if (sb.length() > 0) {
			bingo(10000, AlertItem.RISK_MEDIUM, AlertItem.SUSPICIOUS, "", "", sb.toString());
		}

	}

}