/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.scan;

class TestServerWebLogic extends TestServerDefault {

    public String toString() {
        return "TestServerWebLogic";
    }

	public String getTestName() {
		return "Server WebLogic";
	}
	
	protected int getAlertID() {
		return 5;
	}


	protected void init(ParsedEntity entity) throws Exception {
		super.init(entity);

		// WebLogic server 8.1 examples

		addTest("/patient","register.do,login.do");
		addTest("/admin", "login.do");
		addTest("/physican", "login.do");

		addTest("/examplesWebApp","index.jsp");
		// order parser example
		addTest("/examplesWebApp","OrderParser.jsp?xmlfile=C:/bea/weblogic81/samples/server/examples/src/examples/xml/orderParser/order.xml");
		// web services example
		addTest("/examplesWebApp","WebservicesEJB.jsp");
		// enterprise java bean example		
		addTest("/examplesWebApp","EJBeanManagedClient.jsp");
		// JSP example
		addTest("/examplesWebApp","InteractiveQuery.jsp");
		// servlet example
		addTest("/examplesWebApp","SessionServlet");

		// ***********************
		
		// WebLogic 8.1 Integration end-to-end examples
		
		addTest("/e2ePortalProject","Login.portal");
		
		// WebLogic Administration portal - not an example
		addTest("/portalAppAdmin","login.jsp");
		
		// weblogic Integration Administration console
		addTest("/","wliconsole");

	}

}