
/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;


class TestServerWebSphere extends TestServerDefault {

    public String toString() {
        return "TestServerWebSphere";
    }
    
	public String getTestName() {
		return "Server IBM WebSphere";
	}
	
	protected int getAlertID() {
		return 6;
	}


	protected void init(ParsedEntity entity) throws Exception {
		super.init(entity);

		addTest("servlet","HelloWorldServlet");
		addTest("servlet","SimpleServlet");
		addTest("servlet","aphtpassword");

		addTest("webapp/examples","HitCount");

		// for admin.war
		addTest("admin","logon.jsp,secure/logon.jsp");		

		// default_app.war
		addTest("servlet","snoop,snoop2,SnoopServlet,hello,ErrorReporter");

		// examples.ear
		addTest("webapp/examples","login.html,simple.jsp,ErrorServlet,ping,showcfg,HitCount,verify,HelloPervasive");
		addTest("WebSphereSamples",",YourCo/main.html");
		addTest("WebSphereSamples/SingleSamples","Increment/increment.html,AccountAndTransfer/create.html");
		addTest("/","WebSphereSamples/");

		// PetStore samples
		addTest("estore","index.html,annotated-index.html,populate");
		addTest("/","theme");

		// default indexable directory
		addTest("/","IBMWebAS");
	}

}