/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.scan;

import java.net.URI;

class TestTomcatViewSource extends AbstractAppTest {


	TestTomcatViewSource() {
	}

	public String getTestName() {
		return "Tomcat View Source";
	}

	private boolean buildHeader() {
		URI uri = getEntity().getURIHostPath();
		String sUri = uri.toString();
		if (!sUri.endsWith(".jsp")) {
			return false;
		}
		
		if (!sUri.endsWith("/")) {
			sUri = sUri + "/";
		}
		sUri = sUri + "\u0000.html";
		getRequestHeader().setURI(sUri);

		return true;	
	}

	protected void scan() throws Exception {
		boolean result		= false;

		if (!buildHeader()) {
			return;
		}
		
		writeStatus("TomcatViewSource: " + getRequestHeader().getURIHostPath());

		sendAndReceive();
		
		if (!isFileExist(getEntity(), getRequestHeader(), getResponseHeader(), getResponseBody())) {
			return;
		}

		result = true;		
		if (result) {
			writeOutput("Warning - Directory Browsing found: " + getRequestHeader().getURIHostPath());
		}

	}
	



}