/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import java.io.IOException;

import com.proofsecure.paros.Global;

class TestXSS extends TestAbstractParam {

	// should not be changed to static as Global may not be ready
	private String XSS1 = "<SCRIPT>alert(" + '"' + Global.getEyeCatcher() + '"' + ");</SCRIPT>";
	private String XSS2 = "<SCRIPT>alert(" + Global.getEyeCatcher() + ");</SCRIPT>";

	TestXSS() {
	}

    public String toString() {
        return "TestXSS";
    }
    
	public String getTestName() {
		return "Cross-site Scripting";
	}
	
	
	
	protected void check(boolean isBody, String paramKey, String paramValue, String query, int insertPos) throws IOException {

		String newQuery = null;
		int pos = 0;
		String result = null;
		
		// try XSS1
		newQuery = insertQuery(query, insertPos, paramKey + "=" + XSS1);
		createMessage(isBody, newQuery);
		sendAndReceive();

		//	no need to have 200 response
		//	if (getResponseHeader().getStatusCode() != HttpStatusCode.OK) {
		//	return;
		//}
		
		result = getResponseBody().toString();
		pos = result.indexOf(XSS1);
		if (pos >  -1) {
			bingo(20000, AlertItem.RISK_MEDIUM, AlertItem.WARNING, "", paramKey, "");
			return;
		}


		// try XSS2
		newQuery = insertQuery(query, insertPos, paramKey + "=" + XSS2);				
		createMessage(isBody, newQuery);
		sendAndReceive();

		//	no need to have 200 response
		//	if (getResponseHeader().getStatusCode() != HttpStatusCode.OK) {
		//	return;
		//}
		
		result = getResponseBody().toString();
		pos = result.indexOf(XSS2);
		if (pos ==  -1) {
			return;
		}
		
		if (result.charAt(pos-1) != '"' && result.charAt(pos+XSS2.length()) != '"') {
			// check if adjacent character is double quote.  If so, maybe OK
			bingo(20000, AlertItem.RISK_MEDIUM, AlertItem.SUSPICIOUS, "", paramKey, "");
			return;
		}		
	}
	
	protected void scan() throws Exception {
		boolean skip = (getEntity().mState == ParsedEntity.DO_NOT_SCAN);
			
		writeStatus("Cross-site Script: " + (skip? "(skipped) " : "") + getRequestHeader().getURIHostPath());
		if (skip) {
			return;
		}
		init();
		checkUrlOrBody(false, myQuery);
		checkUrlOrBody(true, myReqBody.toString());
	}

}