/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.spider;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.URL;

import javax.swing.BorderFactory;
import javax.swing.JOptionPane;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpRequestHeader;

public class SpiderGUI extends Spider {
	WaitingDialog waitingDialog  = null;
	
	public SpiderGUI(){
	}


	private String getURLfromGUI(){
        // Modal dialog with OK/cancel and a text field
      //JOptionPane dialog = new JOptionPane();      
			return JOptionPane.showInputDialog(Global.parosFrame, "Please type the URL for spider\r\n(Note: website with invalid SSL certificate cannot be crawled)", "http://");

	}
	

	public boolean init(){
//    this.initSecureConnection();

		String su = getURLfromGUI();
		if (su==null){
			
			return false;
		}

//		Global.proxy.stopServer();
//		Global.SSLProxy.stopServer();
		

//		System.out.println(su);
		URL u = null;
		try{
			u = new URL(su);
	    if (u.getFile().equals(""))
	      u = new URL(u.toString() + "/");
  	}catch(Exception e){
  		JOptionPane.showMessageDialog(Global.parosFrame, "URL is invalid"); 
  		
  	}
   	this.setStartURL(u);

		if (!(Global.config.getProxyChainName()==null) ){
			if (Global.config.getProxyChainName().equals("") || !Global.config.useProxy(u.getHost())){
				this.setProxy("", "");
			}
			else
	    	this.setProxy(Global.config.getProxyChainName(), "" + Global.config.getProxyChainPort());
	  }
	  
	  waitingDialog = new WaitingDialog( Global.parosFrame, false, this);
		com.proofsecure.paros.util.Util.centreChild(Global.parosFrame, waitingDialog );
	  waitingDialog.show();
	  
		return true;
	}


	protected void wrapup(){	 
  	if (hconn!=null)
   		hconn.disconnect();

	  Global.parosFrame.logAppend("Total " + links.getUrlDone().size() + " links crawled." + "\r\n"); 
//	  links.listUrlDone();	  
	  Global.parosFrame.logAppend(links.listUrlRejected());    
    isStarted = false;
//    Global.SSLProxy = new SSLProxy(Global.config.getProxyIP(), Global.config.getProxyPortSSL());
//		Global.proxy.startServer();
//		Global.SSLProxy.startServer();
    if (waitingDialog !=null){
    	waitingDialog.dispose();
    }
    
		Global.parosFrame.setStatus("  ");
		Global.treePanel.TreeRefresh();
	}


	public void logError(String s){
		//JOptionPane.showMessageDialog(Global.parosFrame, "Spider failed with error:\n " + s); 
		Global.parosFrame.logAppend("!!! Error: " + s + " !!!\r\n");
		  		
	}
	
	protected void log(URL ur, HttpRequestHeader reqHeader) throws Exception{
//	  com.proofsecure.paros.scan.ParsedEntity p = new com.proofsecure.paros.scan.ParsedEntity("",new URI(ur.toString()),mSecureFlag);	
//		Global.treePanel.addPath(p);
	
		Global.treePanel.setTree(reqHeader, new HttpBody());
		Global.parosFrame.setStatus("Crawled  " + ur.toString());
//		paros.Global.treePanel.TreeRefresh();
	}

/*
  public void initSecureConnection(){
			HttpsURLConnection.setDefaultSSLSocketFactory(Global.ssl.getClientSocketFactory("SSL"));
  }
*/
  public static void main(String[] args) throws Exception{

    if (args.length<1){
       System.out.println(USAGE); 
       return;
    }
    if (args.length==2 && args[1].indexOf(":")==-1){
       System.out.println(USAGE); 
       return;
    }

    SpiderGUI s = new SpiderGUI();

    s.initSecureConnection();

    URL url = new URL(args[0]);
    if (url.getFile().equals(""))
      url = new URL(url.toString() + "/");

    s.setStartURL(url);

    if (args.length==2){  // proxy argument
      String[] proxyArg = args[1].split(":");
      //s.setProxy("127.0.0.1","8080");
      s.setProxy(proxyArg[0],proxyArg[1]);
    }

  	s.start();
//    s.startCrawl();
  }


	class WaitingDialog extends javax.swing.JDialog {
		private Spider spider = null;

    private javax.swing.JButton btnCancel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;

    /** Creates new form MenuOptions */
    WaitingDialog(java.awt.Frame parent, boolean modal, Spider s) {
        super(parent, modal);
        spider = s;
        initComponents();
    }

    private void initComponents() {//GEN-BEGIN:initComponents

				getContentPane().setLayout(new java.awt.GridLayout(2,1));

//        setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
                
        btnCancel = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        
        setTitle(Global.APP_TITLE);

        setResizable(false);
        setBackground(java.awt.Color.lightGray);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog();
            }
        });
        
        btnCancel.setText("Stop");
//        btnCancel.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));

        btnCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCancelActionPerformed(evt);
            }
        });
        
        jLabel1.setText("Spider is running.");
        jLabel1.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
//        jLabel2.setText("Closing this window will stop it.");
        getContentPane().add(jLabel1);
//        getContentPane().add(jLabel2, BorderLayout.CENTER);
        getContentPane().add(btnCancel);

        pack();
    }//GEN-END:initComponents

    private void btnCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCancelActionPerformed
        closeDialog();
    }//GEN-LAST:event_btnCancelActionPerformed

    /** Closes the dialog */
    private void closeDialog() {//GEN-FIRST:event_closeDialog
			spider.setStop();
			dispose();
    }//GEN-LAST:event_closeDialog

	public void show(Dimension parentSize){
		
		Dimension frameSize = this.getPreferredSize();
		  
		  if (parentSize == null){
			  	// get the desktop screen size
     		parentSize = Toolkit.getDefaultToolkit().getScreenSize();
	    }
	      
	    if (frameSize.height > parentSize.height) {
	      frameSize.height = parentSize.height;
	    }
	    if (frameSize.width > parentSize.width) {
	      frameSize.width = parentSize.width;
	    }
	    
	    this.setLocation((parentSize.width - frameSize.width) / 2, (parentSize.height - frameSize.height) / 2);
    	
      this.pack();
      this.show();  	
	}

}

}


