/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.spider;

import java.net.*;
import java.util.Vector;

class Website {
	URI mURI;
	String mSiteName;
	int mPort;
	Vector mUrlHistory; //ContentType  // url
	Vector mOtherSiteUrl = new Vector();
	//Vector raw // can be skipped
	Vector mServerType;
	Vector mCookies; // url/cookie
	Vector mAuth; // url/auth(user/passwd)
	//TreeGUI hierarchy;

	Website(String s) {
		mUrlHistory = new Vector();
		try {
			mURI = new URI(s);
			if (!mURI.isAbsolute()) {
				// use default
				mURI = (new URI("http://localhost/")).resolve(mURI);
			}

			// get Sitename, port
			mSiteName = mURI.getHost();
			mPort = mURI.getPort();
			if (mPort == -1) { // use default
				if (mURI.toURL().getProtocol().equalsIgnoreCase("http")) {
					mPort = 80;
				} else if (
					mURI.toURL().getProtocol().equalsIgnoreCase("http")) {
					mPort = 443;
				}
			}

			// simplify mURI in format http//sitename:port/
			//mURI = new URI(mURI.toURL().getProtocol()+ "://" + mSiteName + ":" + mPort + "/");
		} catch (Exception e) {
			logError(e.getMessage());
		}
	}

	/*
	 * return URL with hostname only
	 */
	public String getSimplifiedHostURL() {

		String s = null;

		try {
			s =
				mURI.toURL().getProtocol()
					+ "://"
					+ mSiteName
					+ ":"
					+ mPort
					+ "/";
		} catch (MalformedURLException e) {
			logError(e.getMessage());
		}
		return s;
	}

	public URI getURI() {
		return mURI;
	}

	public Vector getHistory() {
		return mUrlHistory;
	}

	/* add link to mUrlHistory */
	public void addLink(URI uri) {
		if (!uri.isAbsolute())
			uri = mURI.resolve(uri);

		if (mUrlHistory.indexOf(uri) == -1) // check duplicated links first
			mUrlHistory.add(uri);
	}

	/*
	 * ****************************************************************
	 * OtherLink functions
	 */
	public Vector getOtherLink() {
		return mOtherSiteUrl;
	}
	public void addOtherLink(URI uri) {
		if (mOtherSiteUrl.indexOf(uri) == -1) // check duplicated links first
			mOtherSiteUrl.add(uri);
	}
	public void clearOtherLink() {
		mOtherSiteUrl.clear();
	}
	/*
	 * ****************************************************************
	 */

	private void list(Vector v) {
		String url;
		//	    for (Enumeration e = v.elements() ; e.hasMoreElements() ;) {
		for (int i = 0; i < v.size(); i++) {
			//	      System.out.println("list: " + (String)(e.nextElement())); 
			System.out.println("list: " + (String) (v.elementAt(i)));
		}
	}

	/*
		  protected Vector resolveURI(Vector vector){
				URI uri;
				
				Vector result=new Vector();
		  	try{	
			  	for (int i=0;i< vector.size();i++){
			  		if (vector.elementAt(i) instanceof URL){
		 					uri = new URI(((URL)vector.elementAt(i)).toExternalForm());	  			
			  		}
			  		else if (vector.elementAt(i) instanceof URI){
			  			uri = (URI)vector.elementAt(i);
			  		}
			  		else{  // string
			  			uri = new URI((String)(vector.elementAt(i)));
			  		}
	//		  		System.out.println(uri);
						if (!uri.isAbsolute()){
							uri = mURI.resolve(uri);										
			  		}
				
						//if (uri.toString().toLowerCase().startsWith(mURI.toString().toLowerCase()))						
						if (uri.getHost().toLowerCase().equals(mSiteName)){
							result.add(uri.toString());
							addLink(uri);
						}
						else{
	//						addOtherLink(uri);	// add links to other sites to mOtherSiteUrl
						}
			  	}	
				}catch(Exception e){
					logError(e.getMessage());			
				}  	
		  	return result;
		  }
	*/

	protected Vector resolveURI(Vector vector, URI baseURI) {
		URI uri;
		//			list(vector);
		Vector result = new Vector();
		try {
			for (int i = 0; i < vector.size(); i++) {
				if (vector.elementAt(i) instanceof URL) {
					uri = new URI(((URL) vector.elementAt(i)).toExternalForm());
				} else if (vector.elementAt(i) instanceof URI) {
					uri = (URI) vector.elementAt(i);
				} else { // string
					uri = new URI((String) (vector.elementAt(i)));
				}
				if (!uri.isAbsolute()) {
					uri = baseURI.resolve(uri);
					//		  			logError("DEBUG " + uri.toString());
				}

				// skip non-http links with schemes mailto...
				if (!uri.getScheme().toLowerCase().startsWith("http"))
					continue;

				//if (uri.toString().toLowerCase().startsWith(mURI.toString().toLowerCase()))						
				if (uri
					.getHost()
					.toLowerCase()
					.equals(mSiteName.toLowerCase())) {
					result.add(uri.toString());
					addLink(uri);
				} else {
					addOtherLink(uri);
					// add links to other sites to mOtherSiteUrl
				}
			}
		} catch (Exception e) {
			logError("Error: " + e.getMessage());
		}

		//			list(result);
		return result;
	}


	public void buildTree() {
	}

	public String toString() {
		return mURI.toString();
	}

	public void logError(String s) {
		System.out.println(s);
	}

	public String getRequestHeader() {
		String s = null;

		return s;
	}

	// conversion among URL, URI and String, public called by others
	public static String URItoString(URI u) {
		return u.toString();
	}
	public static String URLtoString(URL u) {
		return u.toExternalForm();
	}
	public static URI StringtoURI(String s) throws URISyntaxException {
		return new URI(s);
	}
	public static URL StringtoURL(String s) throws MalformedURLException {
		return new URL(s);
	}
	public static URL URItoURL(URI u) throws MalformedURLException {
		return u.toURL();
	}
	public static URI URLtoURI(URL u) throws URISyntaxException {
		return (new URI(u.toExternalForm()));
	}

	/*
	 * return the directory URL for the link
	 */
	public static String getLinkDirectory(URI uri) {
		String s = uri.toString();
		int i = -1;
		if ((i = s.lastIndexOf("/")) != -1)
			return s.substring(0, i + 1);
		else
			return null;
	}

}