/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.text.JTextComponent;
import javax.swing.JFrame;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.util.Util;

public final class FindDialog extends javax.swing.JDialog {

    private javax.swing.JButton btnFind;
    private javax.swing.JButton btnCancel;
    private javax.swing.JTextField txtFind;
    private javax.swing.JLabel jLabel1;

    /** Creates new form MenuOptions */
    public FindDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }

    private void initComponents() {//GEN-BEGIN:initComponents

        btnFind = new javax.swing.JButton();
        btnCancel = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        txtFind = new javax.swing.JTextField();
        
        getContentPane().setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        setTitle(Global.APP_TITLE);

        setResizable(false);
        setBackground(java.awt.Color.lightGray);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        btnFind.setText("Find");
        btnFind.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnFindActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.ipadx = 18;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints1.weightx = 0.5;
        gridBagConstraints1.weighty = 0.5;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(btnFind, gridBagConstraints1);
        
        btnCancel.setText("Cancel");
        btnCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCancelActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints1.weightx = 0.5;
        gridBagConstraints1.weighty = 0.5;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(btnCancel, gridBagConstraints1);

        jLabel1.setText("Find what:");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 1;
        //gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 0.2;
        gridBagConstraints1.weighty = 0.5;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jLabel1, gridBagConstraints1);

        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 0.8;
        gridBagConstraints1.weighty = 0.5;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(txtFind, gridBagConstraints1);
        
        pack();
    }//GEN-END:initComponents

    private void btnCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCancelActionPerformed
        // Add your handling code here:
 	 	dispose();
    }//GEN-LAST:event_btnCancelActionPerformed

    private void btnFindActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnOKActionPerformed
		JTextComponent txtComp = null;
		try {
			JFrame parent = (JFrame) (this.getParent());
			Component c = parent.getMostRecentFocusOwner();
			if (c instanceof JTextComponent) {
				txtComp = (JTextComponent) c;
		        String findText = txtFind.getText().toLowerCase();
        		String txt = txtComp.getText().toLowerCase();
		        int startPos = txt.indexOf(findText, txtComp.getCaretPosition());
		        int length = findText.length();
				if (startPos > -1) {
					Util.writeStatus("Found");
					txtComp.select(startPos,startPos+length);
		 			txtComp.requestFocus();
		 		} else {
		 			Util.writeStatus("End of search.");
		 			Util.beep();
		 			Util.sleep(200);
		 			Util.writeStatus(" ");
		 		}
		 	}
		} catch (Exception e) {
		}

    }//GEN-LAST:event_btnOKActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        dispose();
    }//GEN-LAST:event_closeDialog

	public void show(Dimension parentSize){
		
		Dimension frameSize = this.getPreferredSize();
		  
		  if (parentSize == null){
			  	// get the desktop screen size
     		parentSize = Toolkit.getDefaultToolkit().getScreenSize();
	    }
	      
	    if (frameSize.height > parentSize.height) {
	      frameSize.height = parentSize.height;
	    }
	    if (frameSize.width > parentSize.width) {
	      frameSize.width = parentSize.width;
	    }
	    
	    this.setLocation((parentSize.width - frameSize.width) / 2, (parentSize.height - frameSize.height) / 2);
    	
      this.pack();
      this.show();  	
	}

}