/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

import com.proofsecure.paros.FunctionManager;

public class FunctionPanel extends JPanel{
	protected String HINT ="";
  protected FunctionManager fctMgr = null;
  private JTable jTable1 = null;
  private JScrollPane jScrollPane3 = new JScrollPane();
  
  // button declarations
	private final String BtnName1 = "Enable All";
	private final String BtnName2 = "Disable All";
  private JButton loadButton = new JButton();
  private JButton saveButton = new JButton();
  private JScrollPane btntScrollPane = new JScrollPane();
  private Box buttons;
  protected JTextField uppertext =null;

  // private data
  private Vector header = new Vector(); 
  private Vector data;  // point to the enablelist of FilterManager
  private DefaultTableModel dm;
  
  public FunctionPanel(com.proofsecure.paros.FunctionManager f){
    super();    
   	fctMgr = f;
   	init();

	}

  public FunctionPanel(com.proofsecure.paros.FunctionManager f, String desc){
    super();    
   	fctMgr = f;
   	init();
		setHint(desc);
	}

	public void setHint(String s){
		HINT = s;
		if (uppertext!=null){
    	uppertext.setText(HINT);
    	uppertext.repaint();
    }
	}

  public void init(){
    initData();
    initUI();
  }


  private void initData(){

    // init data
    if (fctMgr!=null){
        data = fctMgr.getDataModel();
        if (data.size() == 0){
          // no filters 
        }
    
		    String[] headerName = fctMgr.getHeaderName();
		    header.add(headerName[0]);
		    header.add(headerName[1]);
		    header.add(headerName[2]);
    }

    
    dm = new DefaultTableModel() {
              public boolean isCellEditable(int row, int col) {
                  if (col > 1 ) {
                      return false;
                  } else {
                      return true;
                  }
              }
              public Class getColumnClass(int col) { 
                   if (col == 0) {
                        return Boolean.class;
                   }
                   else if (col == 1) {
                        return JDialog.class;
                   } else {
                        return String.class;
                   }
              }
         };   
                    
    dm.setDataVector(data,header);
}

  private void initUI(){

    // set JTable componene=t         
    jTable1 = new JTable() {        
        public Component prepareRenderer(TableCellRenderer renderer,
                                         int rowIndex, int vColIndex) {
            Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
            if (vColIndex != 0 && !isCellSelected(rowIndex, vColIndex)) {
                c.setBackground(SystemColor.activeCaptionBorder);
            } else {
                // If not shaded, match the table's background
//                c.setBackground(Color.LIGHT_GRAY);
            }
            return c;
        }
    };

    jTable1.setModel(dm);
    jTable1.setColumnSelectionAllowed(false);
    jTable1.setRowSelectionAllowed(false);
    jTable1.getTableHeader().setReorderingAllowed(false);

		setUpFilterEditor(jTable1);

    int width = 60;
    int vColIndex = 0;
    TableColumn col = jTable1.getColumnModel().getColumn(vColIndex);
    col.setMinWidth(width);
    col.setMaxWidth(width);    
    col.setPreferredWidth(width);
    col.setCellRenderer(new CheckBoxRenderer());

    width = 100;
    vColIndex = 1;
    col = jTable1.getColumnModel().getColumn(vColIndex);
    col.setMinWidth(width);
    col.setMaxWidth(width+width+width);    
    col.setPreferredWidth(width);


    this.setLayout(new BorderLayout());
    jScrollPane3.getViewport().add(jTable1, null);

		setButtons();
		
    this.add(jScrollPane3, BorderLayout.CENTER);  
    this.add(btntScrollPane, BorderLayout.SOUTH);
    uppertext = new JTextField();
                uppertext.setBackground(SystemColor.activeCaptionBorder);
    uppertext.setText(HINT);
    this.add(uppertext, BorderLayout.NORTH);


    if (data.size() == 0){
      saveButton.setEnabled(false);      
      loadButton.setEnabled(false);      
    }
    else{    
      saveButton.setEnabled(true);      
      loadButton.setEnabled(true);      
    }   
   
  }

	private void setButtons(){
    // set buttons
    buttons = Box.createHorizontalBox();
    buttons.add(loadButton, null);
    buttons.add(saveButton, null);
    btntScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
    btntScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
    btntScrollPane.getViewport().add(buttons, null);

    loadButton.setText(BtnName1);
    loadButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
//			((Vector)(data.elementAt(0))).set(0, Boolean.TRUE);			
			int i ;			
			for (i=0; i< jTable1.getRowCount();i++){
				jTable1.setValueAt(Boolean.TRUE, i, 0);
			}			

      }
    });
    saveButton.setText(BtnName2);
    saveButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
			int i ;			
			for (i=0; i< jTable1.getRowCount();i++){
				jTable1.setValueAt(Boolean.FALSE, i, 0);
			}			
      }
    });

	}


  class CheckBoxRenderer extends JCheckBox implements TableCellRenderer{ 
        public CheckBoxRenderer(){
         super();
         this.setHorizontalAlignment(SwingConstants.CENTER);
        }
        public Component getTableCellRendererComponent(JTable table,
               Object value, boolean isSelected, 
               boolean hasFocus, int row, int column) { 
                       setSelected(((Boolean)value).booleanValue()); 
                       return this; 
                 }        
                
        

    // override the following functions for better performace                 
    public void validate() {}
    public void revalidate() {}
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {}
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {}
           
  }

    //Set up the editor 
    private void setUpFilterEditor(JTable table) {
        //First, set up the button that brings up the dialog.
        final JButton button = new JButton();
        final FilterEditor filterEditor = new FilterEditor(button);
        table.setDefaultEditor(JDialog.class, filterEditor);
    }


           
    class FilterEditor extends DefaultCellEditor {
		JDialog current = null;

        public FilterEditor(JButton b) {
                super(new JCheckBox()); 
            editorComponent = b;
            setClickCountToStart(1); 

            b.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    fireEditingStopped();
                }
            });
        }

        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        public Object getCellEditorValue() {
        	// show dialog after clicked button
						current.show();
            return current;// currentColor;
        }

        public Component getTableCellEditorComponent(JTable table, 
                                                     Object value,
                                                     boolean isSelected,
                                                     int row,
                                                     int column) {
       		if (value != null && value instanceof JDialog){
       			// display text when clicked
            	((JButton)editorComponent).setText(value.toString());
	       		current = (JDialog)value; //XXXDoublecheck this is OK
            }
            else{
            	((JButton)editorComponent).setText("");            
            }
            return editorComponent;
        }
    }

  
}


