/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

import com.proofsecure.paros.Global;

public class LicenseFrame extends JFrame {
  private BorderLayout borderLayout1 = new BorderLayout();
  private JPanel jPanel1 = new JPanel();
  private JButton jButton1 = new JButton();
  private JScrollPane jScrollPane1 = new JScrollPane();
  private TitledBorder titledBorder1;
  private TitledBorder titledBorder2;
  private JPanel jPanel2 = new JPanel();
  private JLabel jLabel1 = new JLabel();
  private TitledBorder titledBorder3;
  private TitledBorder titledBorder4;
  private TitledBorder titledBorder5;
  private JButton jButton2 = new JButton();
  private JTextPane License_Content = new JTextPane();
  private Border border1;

  boolean isAcceptLicense = false;

  public LicenseFrame() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  public boolean isAcceptLicense(){
  	return isAcceptLicense;
  }

  public void showFrame() {
//    frame = new MainFrame();
    //Validate frames that have preset sizes
    //Pack frames that have useful preferred size info, e.g. from their layout
      pack();
      validate();

      makeLicense();

    //Center the window
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = getSize();
    if (frameSize.height > screenSize.height) {
      frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width) {
      frameSize.width = screenSize.width;
    }
    setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    setVisible(true);

  }

  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
    }
  }

	private void makeLicense() {

		String remoteUrl = "http://www.statistica.unimib.it/utenti/dellavedova/software/artistic2.html";
		String localUrl = "file:"
                + System.getProperty("user.dir")
                + System.getProperty("file.separator")
                + "TheClarifiedArtisticLicense.htm";
                
    	try{
			License_Content.setPage(localUrl);
    	} catch (IOException e){
      		//try {
      		//	License_Content.setPage(localUrl);
			//} catch (IOException e1) {
				e.printStackTrace();
	      		JOptionPane.showMessageDialog(new JFrame(), "Error: setting file is missing. Program will exit.");
	      		System.exit(0);
	    	//}
	    }
	 }
	 
  private void jbInit() throws Exception {

    border1 = BorderFactory.createCompoundBorder(new EtchedBorder(EtchedBorder.RAISED,Color.white,new Color(178, 178, 178)),BorderFactory.createEmptyBorder(4,4,4,4));
    setIconImage(Toolkit.getDefaultToolkit().createImage("paros_logo.gif"));

    titledBorder1 = new TitledBorder("");
    titledBorder2 = new TitledBorder("");
    titledBorder3 = new TitledBorder("");
    titledBorder4 = new TitledBorder("");
    titledBorder5 = new TitledBorder("");
    this.getContentPane().setLayout(borderLayout1);
    jButton1.setBackground(Color.lightGray);
    jButton1.setFont(new java.awt.Font("Dialog", 1, 12));
    jButton1.setForeground(Color.darkGray);
    jButton1.setText("Accept");
    jButton1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButton1_actionPerformed(e);
      }
    });


//    this.setModal(true);
    this.setTitle(Global.APP_TITLE);
    jScrollPane1.setForeground(Color.white);
    jScrollPane1.setMinimumSize(new Dimension(540, 400));
    jScrollPane1.setPreferredSize(new Dimension(540, 400));
    jPanel1.setBackground(Color.lightGray);
    jPanel1.setBorder(titledBorder1);
    jPanel1.setMinimumSize(new Dimension(179, 50));
    jPanel1.setPreferredSize(new Dimension(179, 50));
    jLabel1.setBackground(Color.lightGray);
    jLabel1.setFont(new java.awt.Font("Dialog", 1, 20));
    jLabel1.setForeground(Color.darkGray);
    jLabel1.setToolTipText("");
    jLabel1.setHorizontalAlignment(SwingConstants.LEFT);
    jLabel1.setText("Paros License Agreement - the Clarified Artistic License");
    jPanel2.setBackground(Color.lightGray);
    jPanel2.setForeground(Color.white);
    jButton2.setBackground(Color.lightGray);
    jButton2.setFont(new java.awt.Font("Dialog", 1, 12));
    jButton2.setForeground(Color.darkGray);
    jButton2.setText("Decline");
    jButton2.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButton2_actionPerformed(e);
      }
    });
    License_Content.setBorder(border1);
    License_Content.setToolTipText("");
    License_Content.setEditable(false);
    License_Content.setMargin(new Insets(3, 3, 3, 3));
    //License_Content.setLineWrap(true);
    this.getContentPane().add(jPanel1, BorderLayout.SOUTH);
    jPanel1.add(jButton1, null);
    jPanel1.add(jButton2, null);
    this.getContentPane().add(jScrollPane1, BorderLayout.CENTER);
    jScrollPane1.getViewport().add(License_Content, null);
    this.getContentPane().add(jPanel2, BorderLayout.NORTH);
    jPanel2.add(jLabel1, null);
  }

  void jButton2_actionPerformed(ActionEvent e) {
    System.exit(0);

  }

  void jButton1_actionPerformed(ActionEvent e) {
    isAcceptLicense = true;
    this.removeAll();
    this.dispose();
  }
}