/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;


public class MainFrame_AboutBox extends JWindow implements ActionListener{

	private Font myfont = new java.awt.Font("Dialog", 1, 12);
//	private Color myColor = new Color(153, 102, 153);
	private Color myColor = new Color(0,4,196);
  private JPanel panel1 = new JPanel();
  private JPanel insetsPanel1 = new JPanel();
  private JPanel insetsPanel2 = new JPanel();
  private JPanel insetsPanel3 = new JPanel();
  private JButton button1 = new JButton();
  private JLabel imageLabel = new JLabel();
  private GridLayout gridLayout1 = new GridLayout();
  private String product = com.proofsecure.paros.Global.APP_TITLE;
  private String version = com.proofsecure.paros.Global.APP_VERSION;
  private String copyright = "Copyright(c) 2003-2004 ProofSecure.com";
  private String copyright_detail = 
  	"\r\nThis program is free software; you can redistribute it and/or\r\n"
	+ "modify it under the terms of the Clarified Artistic License\r\n"
	+ "as published by the Free Software Foundation.\r\n\r\n"
	+ "This program is distributed in the hope that it will be useful,\r\n"
	+ "but WITHOUT ANY WARRANTY; without even the implied warranty\r\n"
	+ "of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\r\n"
	+ "See the Clarified Artistic License for more details.\r\n";

  private JLabel label1 = new JLabel(product, JLabel.LEFT);
  private JLabel label2 = new JLabel(" ", JLabel.LEFT);
  private JLabel label3 = new JLabel(copyright, JLabel.LEFT);
  private JTextArea txtCopyrightDetail = new JTextArea(copyright_detail);
  private Border border1;
  private TitledBorder titledBorder1;


  public MainFrame_AboutBox(Frame parent, boolean hasButton) {
    super(parent);
//    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit(hasButton);
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }


  private void jbInit(boolean hasButton) throws Exception  {
    border1 = BorderFactory.createEtchedBorder(Color.white,new Color(134, 134, 134));
    titledBorder1 = new TitledBorder("");
    this.getContentPane().setBackground(Color.lightGray);
    this.setForeground(Color.white);
    panel1.setLayout(new BorderLayout());
    insetsPanel2.setBackground(myColor);
    insetsPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    insetsPanel2.add(imageLabel, BorderLayout.CENTER);
//    gridLayout1.setRows(3);
//    gridLayout1.setColumns(1);
    label1.setFont(new java.awt.Font("Dialog", 1, 18));
    label1.setForeground(Color.white);
    label1.setAlignmentX(Component.LEFT_ALIGNMENT);

    label3.setForeground(Color.white);
    label3.setAlignmentX(Component.LEFT_ALIGNMENT);
    txtCopyrightDetail.setForeground(Color.white);
    //txtCopyrightDetail.setPreferredSize(new Dimension(330, 100));
    txtCopyrightDetail.setBackground(myColor);
    txtCopyrightDetail.setFont(new java.awt.Font("Dialog", 0, 11));
    txtCopyrightDetail.setEditable(false);
    txtCopyrightDetail.setAlignmentX(Component.LEFT_ALIGNMENT);

    insetsPanel3.setLayout(new BoxLayout(insetsPanel3, BoxLayout.Y_AXIS));
    insetsPanel3.setBackground(myColor);
    insetsPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    insetsPanel3.add(label1, null);
    insetsPanel3.add(label2, null);
    insetsPanel3.add(label3, null);
    insetsPanel3.add(txtCopyrightDetail, null);
//    button1.setBackground(new Color(204, 102, 153));
    button1.setBackground(new Color(0, 0, 255));
//    button1.setBackground(myColor);
    button1.setFont(myfont);
    button1.setForeground(Color.white);
    button1.setBorder(border1);
    button1.setText("       Close       ");
    button1.addActionListener(this);
//    imageLabel.setIcon(new ImageIcon(MainFrame_AboutBox.class.getResource("paros_logo.gif")));
    imageLabel.setIcon(new ImageIcon("paros_logo.gif"));
    panel1.setBackground(Color.white);
    panel1.setBorder(titledBorder1);
    insetsPanel1.setBackground(myColor);

    this.getContentPane().add(panel1, BorderLayout.CENTER);

    if (hasButton)
      insetsPanel1.add(button1);
    else{
    	
//    	JLabel label5 = new JLabel();
//	    label5.setFont(myfont);
//	    label5.setForeground(Color.white);
//		label5.setText("Thank you for using our product");

//      insetsPanel1.add(label5);
    }
    
    panel1.add(insetsPanel3, BorderLayout.CENTER);
    panel1.add(insetsPanel2, BorderLayout.WEST);
    panel1.add(insetsPanel1, BorderLayout.SOUTH);
  }

/*
  protected void processWindowEvent(WindowEvent e) {
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      cancel();
    }
    super.processWindowEvent(e);
  }
*/
	public void show(Dimension parentSize){

	
		Dimension frameSize = this.getPreferredSize();
		  
		  if (parentSize == null){
			  	// get the desktop screen size
     		parentSize = Toolkit.getDefaultToolkit().getScreenSize();
	    }
	      
	    if (frameSize.height > parentSize.height) {
	      frameSize.height = parentSize.height;
	    }
	    if (frameSize.width > parentSize.width) {
	      frameSize.width = parentSize.width;
	    }
	    
	    this.setLocation((parentSize.width - frameSize.width) / 2, (parentSize.height - frameSize.height) / 2);
    	this.pack();	
      this.show();  	
	}
  
  void cancel() {
    dispose();
  }
  public void actionPerformed(ActionEvent e) {
    if (e.getSource() == button1) {
      cancel();
    }
  }
/*  
  public static void main(String[] argc){

  	MainFrame_AboutBox dlg = new MainFrame_AboutBox(null, false);
      dlg.show(null);  	
  }
*/
}

