/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.ui;

import java.awt.BorderLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class TrapPanel extends JPanel{

  private static final String TRAPVIEW_TABULAR = "Tabular View";
  private static final String TRAPVIEW_ORIGINAL = "Original View";

  private Pattern pSeparator	= Pattern.compile("([^=&]+)[=]([^=&]*)"); 
   private Matcher matcher2;
   
//  private JPanel jPanel2 = new JPanel();
  private PostTableModel myPostModel = null;
  private boolean isContinue = false;

   private JSplitPane jSplitPane5 = new JSplitPane();   
  private ParosSplitPane jSplitPane4 = new ParosSplitPane();
  private JScrollPane jScrollPane4 = new JScrollPane();
  private JScrollPane jScrollPane5 = new JScrollPane();
  private JPanel jPanel4 = new JPanel();
  private JTextArea txtHeader = new JTextArea();
  private JTextArea txtBody = new JTextArea();
  private JTable jTable2 = new JTable();
  private JScrollPane jScrollPane8 = new JScrollPane();    
  private JScrollPane jScrollPane9 = new JScrollPane();      
  private Box box1;
  private JButton jButton4 = new JButton();
  private JLabel jLabel9 = new JLabel();
  private JLabel jLabel10 = new JLabel();
  private JCheckBox TrapReq = new JCheckBox();
  private JCheckBox TrapResp = new JCheckBox();
  private JLabel jLabel11 = new JLabel();
  private JButton TrapView = new JButton();

  public TrapPanel(){
    super();
    init();
  }
  

  private void init(){
    box1 = Box.createHorizontalBox();
//    box1.setBackground(SystemColor.activeCaptionBorder);
//    box1.setForeground(SystemColor.activeCaptionBorder);
    
    this.setLayout(new BorderLayout());
    this.setBackground(SystemColor.activeCaptionBorder);  
    
    jPanel4.setLayout(new BorderLayout());
    jSplitPane4.setOrientation(JSplitPane.VERTICAL_SPLIT);
    jSplitPane4.setDividerSize(3);
     
       jScrollPane8.getViewport().add(jTable2, null);
    jSplitPane5.add(jPanel4, JSplitPane.LEFT);          
    jSplitPane5.add(jScrollPane8, JSplitPane.RIGHT);
    jSplitPane5.setDividerSize(0);
    
    this.add(jSplitPane5, BorderLayout.CENTER);
    this.add(jScrollPane9, BorderLayout.SOUTH);    

    jLabel9.setText("  ");
    jLabel10.setText("        ");
    TrapReq.setText("Trap Request");
    TrapResp.setText("Trap Response");
    jLabel11.setText("   ");
    TrapView.setText(TRAPVIEW_TABULAR);
    TrapView.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        TrapView_actionPerformed(e);
      }
    });

    jScrollPane9.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
    jScrollPane9.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
//  jScrollPane9.setMinimumSize(new Dimension(100,200));
    jScrollPane9.getViewport().add(box1, null);
//    box1.setBackground(SystemColor.activeCaptionBorder);
//    box1.setForeground(SystemColor.activeCaptionBorder);
    jButton4.setText("Continue");
    jButton4.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButton4_actionPerformed(e);
      }
    });
    box1.add(TrapReq, null);
    box1.add(jLabel10, null);
    box1.add(TrapResp, null);
    box1.add(jLabel11, null);
    box1.add(jButton4, null);
    box1.add(jLabel9, null);
    box1.add(TrapView, null);
        
    jPanel4.add(jSplitPane4.getJSplitPaneHeader(), BorderLayout.WEST);
    jPanel4.add(jSplitPane4, BorderLayout.CENTER);
    jSplitPane4.add(jScrollPane4, JSplitPane.TOP);
    jSplitPane4.add(jScrollPane5, JSplitPane.BOTTOM);    

    txtHeader.setLineWrap(true);
    txtBody.setLineWrap(true);
    jScrollPane5.getViewport().add(txtBody, null);
    jScrollPane4.getViewport().add(txtHeader, null);

    myPostModel = new PostTableModel();
    jTable2.setModel(myPostModel); 
    jScrollPane8.setVisible(false);    
    
    txtHeader.addMouseListener (new MouseAdapter() {
      public void mousePressed (MouseEvent e) {
        if ((e.getModifiers() & InputEvent.BUTTON3_MASK) != 0) {  // right mouse button
          PopupPanel pp = new PopupPanel(txtHeader);   // should pass component to popup
          pp.getPopupMenu().show (e.getComponent(),
            e.getX(), e.getY());
        }
        else{
          super.mousePressed(e);
        }
      }
    });

    txtBody.addMouseListener (new MouseAdapter() {
      public void mousePressed (MouseEvent e) {
        if ((e.getModifiers() & InputEvent.BUTTON3_MASK) != 0) {  // right mouse button
          PopupPanel pp = new PopupPanel(txtBody);   // should pass component to popup
          pp.getPopupMenu().show (e.getComponent(),
            e.getX(), e.getY());
        }
        else{
          super.mousePressed(e);
        }
      }
    });

    
  }

  public boolean isContinue(){
    return isContinue;
  }

  public void setContinue(boolean s){
    isContinue = s;
  }

  public boolean isTrapRequest(){
    return TrapReq.isSelected();
  }

  public boolean isTrapResponse(){
    return TrapResp.isSelected();
  }

  public String getHeader(){
     String result = txtHeader.getText().replaceAll("\\n","\r\n");
     result = result.replaceAll("(\\r\\n)*\\z","") + "\r\n\r\n";
     return result;              
  }

  public String getBody(){
     return txtBody.getText();
  }

  public void setMessage(final String header, final String body){
         
            SwingUtilities.invokeLater(new Runnable() {
//            try {
//              EventQueue.invokeAndWait(new Runnable() {

              public void run() {
                  txtHeader.setText(header.replaceAll("\\r\\n","\n"));
                  txtHeader.setCaretPosition(0);
                  if (body == null) {
                    txtBody.setEnabled(false);
                  } else {
                    txtBody.setEnabled(true);
                    txtBody.setText(body);
                    txtBody.setCaretPosition(0);
                  }              
//                  if (header!=null && header.equals("") && body!=null && body.equals("")){
//		                  txtBody.setEnabled(true);
//                  }
              }
             });
//            }catch(Exception ie){
//              System.out.println(ie.getMessage());
//            }             
  }

  void jButton4_actionPerformed(ActionEvent e) {
    isContinue = true;
  }

  

  void TrapView_actionPerformed(ActionEvent e) {
    String subStr="";
    String subStr2="";
    try{

    if ((TrapView.getText().trim()).equals(TRAPVIEW_ORIGINAL)){
    // do post back
      int row=0;
      String pb = "";
      while (row < 80 && !myPostModel.getValueAt(row,0).equals("")){
        if (row!=0) pb+="&";
        pb += URLEncoder.encode((String)myPostModel.getValueAt(row,0),"UTF8") + "=" + URLEncoder.encode((String)myPostModel.getValueAt(row,1),"UTF8");
        row++;
      }

      final String pb2 = pb;
      

        TrapView.setText(TRAPVIEW_TABULAR);
        txtBody.setText(pb2);
        //jTable2.setVisible(false);
        jScrollPane8.setVisible(false);
        jSplitPane5.setDividerLocation(450);
        (jSplitPane4.getJSplitPaneHeader()).setVisible(true);
        TrapReq.setEnabled(true);
        TrapResp.setEnabled(true);
        jButton4.setEnabled(true);

//      jSplitPane4.setVisible(true);
      return;
    }
    //else{
//    }

    String param = txtBody.getText().trim();



    if (TrapReq.isSelected() && param !=null && !param.equals("")){
      int end = 0;
      int start = 0;
      int row =0, col=0;


    // clear table
      while (row < 80){
        myPostModel.setValueAt("",row,0);
        myPostModel.setValueAt("",row,1);
        row++;
      }
      jSplitPane5.setDividerLocation(0);
      (jSplitPane4.getJSplitPaneHeader()).setVisible(false);
      //jTable2.setVisible(true);
      jScrollPane8.setVisible(true);

      TrapReq.setEnabled(false);
      TrapResp.setEnabled(false);
      jButton4.setEnabled(false);

	  row=0;
	  matcher2 = pSeparator.matcher(param);
	  while (row<80 && matcher2.find()){
		myPostModel.setValueAt(URLDecoder.decode(matcher2.group(1),"8859_1"),row,0);
		myPostModel.setValueAt(URLDecoder.decode(matcher2.group(2),"8859_1"),row,1);
		row++;
					
	  }
/*
      row=0;

      while (row<80 && (end=param.indexOf('=')) != -1){
        // head
        subStr = param.substring(start,end);
        myPostModel.setValueAt(URLDecoder.decode(subStr,"8859_1"),row,col);
        col++;
        start=end+1;
        param = param.substring(start,param.length());
        start=0;
        if ((end=param.indexOf('&'))!=-1){
          // value
          subStr = param.substring(start,end);
          myPostModel.setValueAt(URLDecoder.decode(subStr,"8859_1"),row,col);
          row++;
          col=0;
          start=end+1;
          param = param.substring(start,param.length());
          start=0;
        }
        else{  // maybe last pair
            myPostModel.setValueAt(URLDecoder.decode(param,"8859_1"),row,col);
            TrapView.setText(TRAPVIEW_ORIGINAL);
            return;
        }
      }
      */

      // maybe row > 80, wrapup here      
	  if (row >= 80){ //too many parameters
			System.out.println("Too many parameters in the POST query!");	  	 
	  }
	  
      TrapView.setText(TRAPVIEW_ORIGINAL);
            
      return;
      
    }
    }catch(Exception e4){System.out.println(e4.getMessage()); e4.printStackTrace();return;}

//    TrapView.setEnabled(false);
  }


  class PostTableModel extends AbstractTableModel {
    final String[] columnNames = {"Element", "Value"};
           private Object[][] data = {
              {"", "" },
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
             {"", ""},
              {"", "" },
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
             {"", ""},
              {"", "" },
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
             {"", ""},
              {"", "" },
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
              {"", ""},
             {"", ""},
             {"", ""}
             
            };

    PostTableModel(){
      super();
    }

      public int getColumnCount() {
          return columnNames.length;
      }

      public int getRowCount() {
          return data.length;
      }

      public String getColumnName(int col) {
          return columnNames[col];
      }

      public Object getValueAt(int row, int col) {
          return data[row][col];
      }

      /*
       * JTable uses this method to determine the default renderer/
       * editor for each cell.  If we didn't implement this method,
       * then the last column would contain text ("true"/"false"),
       * rather than a check box.
       */
      public Class getColumnClass(int c) {
          return getValueAt(0, c).getClass();
      }

      /*
       * Don't need to implement this method unless your table's
       * editable.
       */
      public boolean isCellEditable(int row, int col) {
          //Note that the data/cell address is constant,
          //no matter where the cell appears onscreen.
          if (col < 1 || row >= 80) {
              return false;
          } else {
              return true;
          }
      }

      /*
       * Don't need to implement this method unless your table's
       * data can change.
       */
      public void setValueAt(Object value, int row, int col) {
        boolean DEBUG = false;
          if (DEBUG) {
              System.out.println("Setting value at " + row + "," + col
                                 + " to " + value
                                 + " (an instance of "
                                 + value.getClass() + ")");
          }

         if (value==null)
                 value = "";

//             return;
/*
        if (value instanceof Integer){
            JOptionPane.showMessageDialog(new JFrame(), "Wrong Format");
        }
        else if (data[0][col] instanceof Integer
                  && !(value instanceof Integer)) {
              //With JFC/Swing 1.1 and JDK 1.2, we need to create
              //an Integer from the value; otherwise, the column
              //switches to contain Strings.  Starting with v 1.3,
              //the table automatically converts value to an Integer,
              //so you only need the code in the 'else' part of this
              //'if' block.
              //XXX: See TableEditDemo.java for a better solution!!!
              try {
                  data[row][col] = new Integer(value.toString());
                  fireTableCellUpdated(row, col);
              } catch (NumberFormatException e) {
//                  JOptionPane.showMessageDialog(this,
//                      "The \"" + getColumnName(col)
//                      + "\" column accepts only integer values.");
              }
          } else {
*/
              data[row][col] = value;
              fireTableCellUpdated(row, col);
//              Tools.settings.setData(value, row, col);
//              Tools.saveSettings();
//          }

          if (DEBUG) {
              System.out.println("New value of data:");
              printDebugData();
          }
      }

      private void printDebugData() {
          int numRows = getRowCount();
          int numCols = getColumnCount();

          for (int i=0; i < numRows; i++) {
              System.out.print("    row " + i + ":");
              for (int j=0; j < numCols; j++) {
                  System.out.print("  " + data[i][j]);
              }
              System.out.println();
          }
          System.out.println("--------------------------");
      }
  }

  
}