/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.ui;

import java.awt.BorderLayout;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.scan.ParsedFolder;
import com.proofsecure.paros.scan.ParsedURL;
import com.proofsecure.paros.util.Util;

public class TreePanel extends JPanel{

	//private DefaultMutableTreeNode reqTreeRootNode = new DefaultMutableTreeNode("Web Site Hierarchy");
	private ParsedEntity reqTreeRootNode = new ParsedEntity("Web Site Hierarchy");
	private DefaultTreeModel treeModel = new DefaultTreeModel(reqTreeRootNode);
	private JTree reqTree = new JTree(treeModel);
	
	private JScrollPane jScrollPane2 = new JScrollPane();
	
	public TreePanel(){
		super();
		init();
	}
	
	
	private void init() {
		addTreeListener();
		this.setLayout(new BorderLayout());
		jScrollPane2.getViewport().add(reqTree, null);
		this.add(jScrollPane2,BorderLayout.CENTER);    
	}

	public void init(JTree tree) {
		addTreeListener();
		this.setLayout(new BorderLayout());
		jScrollPane2.getViewport().add(tree, null);
		this.add(jScrollPane2,BorderLayout.CENTER);    
	}
	
	/**
	Get the root node.
	*/
	public ParsedEntity getRoot() {
		return reqTreeRootNode;
	}

	/**
	Get the selected node in the tree.
	@return	Selected node.  Return null if no node selected.
	*/
	public ParsedEntity getSelectedParsedEntity() {
		
		DefaultMutableTreeNode node = (DefaultMutableTreeNode) reqTree.getLastSelectedPathComponent(); 			
	    return (ParsedEntity) node;
	}
	
	/*
    public void setTreeNoGUI(String host, String uri, String respcode){
		if (uri.startsWith("http://")){
			uri = uri.substring( ("http://"+host).length(), uri.length());
		}


		addPath(reqTreeRootNode, host+"/"+uri, respcode);
	}
	*/

		// showPath not used
		/*
        public String showPath(DefaultMutableTreeNode top, String uri){
          Vector v = stringToToken(uri);
          String s =  "";
          Enumeration enum = top.children();
          DefaultMutableTreeNode prev_node = top;
          for (int i=0; i < v.size(); i++){
            if  (enum.hasMoreElements()){
              DefaultMutableTreeNode node = (DefaultMutableTreeNode)enum.nextElement();
              if (node.toString().equals(v.elementAt(i))){
                s += node.toString() + "--";
                enum = node.children();
              }
              prev_node = node;
            }
            else{  // add the node
//              prev_node.add(new MutableTreeNode(v.elementAt(i));
              for (int j=i; j < v.size(); j++){
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(v.elementAt(j));
//            System.out.println(child.getUserObjectPath()[0]);
                prev_node.add(child);
                prev_node = (DefaultMutableTreeNode) prev_node.getChildAt(prev_node.getIndex(child));
              }

            }
          }
          return s;
        }
		*/		
		
		/*
        public synchronized void addPath(DefaultMutableTreeNode top, String uri, String respcode){
            Vector v = stringToToken(uri);
            String s =  "";
            DefaultMutableTreeNode prev_node = top;
            Enumeration enum = prev_node.children();
            int cnt = prev_node.getChildCount();
            for (int j=0; j < v.size(); j++){
              boolean childfound=false;
              for (int i=0; i < cnt; i++){
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)enum.nextElement();
                if (node.toString().equals(v.elementAt(j))){  // reset loop and start at child node
                  enum = node.children();
                  prev_node = node;
                  cnt = prev_node.getChildCount();
                  i=0;
                  childfound = true;
                  break;
                }
              }
              if (!childfound){  // add child
                DefaultMutableTreeNode new_node = null;
                if (respcode != null && !respcode.equals(""))
                   respcode += " ";
                for (int z=j; z < v.size(); z++){                  
                  if (z == v.size()-1 && respcode!=null)
                    new_node = new DefaultMutableTreeNode(respcode + (String)(v.elementAt(z)));                  
                else
                    new_node = new DefaultMutableTreeNode((String)(v.elementAt(z)));                  
                  prev_node.add(new_node);
                  prev_node = new_node;
                }

                break;
              }
            }
        }
        */

        public Vector stringToToken(String s){
          Vector sVector = new Vector();
          StringTokenizer tokens = new StringTokenizer(s, "/") ;
          if (s.startsWith("http://")){
            tokens.nextToken();
            tokens.nextToken();
          }
          while (tokens.hasMoreTokens()){
            String st = tokens.nextToken();
            sVector.add(st) ;
//            System.out.println(st);
          }
          return sVector;
        }



  String textReplace(String hdr, String start, String end, String replace){
    int c1=0;
    if ((c1=hdr.indexOf(start))!=-1){
      c1 += start.length();
      StringTokenizer st = new StringTokenizer(hdr.substring(c1), end);
      if (st.hasMoreTokens()){
        String l = st.nextToken();        
        StringBuffer sb = new StringBuffer(hdr);
        sb.replace(c1, c1+l.length(),replace);
        hdr = sb.toString();

      }
    }
  
    return hdr;   
  }
    


    public void addTreeListener(){
		reqTree.addMouseListener (new MouseAdapter() {
            public void mousePressed (MouseEvent e) {
          		if ((e.getModifiers() & InputEvent.BUTTON3_MASK) != 0) {  // right mouse button
            		PopupPanel pp = new PopupPanel(reqTree);   // should pass component to popup
                  	pp.getPopupMenu().show (e.getComponent(),
                  	e.getX(), e.getY());
              	}
              	else{
                	int selRow = reqTree.getRowForLocation(e.getX(), e.getY());
                	TreePath selPath = reqTree.getPathForLocation(e.getX(), e.getY());
                	if(selRow != -1) {
                    	if(e.getClickCount() == 2) {
                    	}
                	}
              	}
              
            }
         });
        
		reqTree.addTreeSelectionListener(new TreeSelectionListener() {
    		public void valueChanged(TreeSelectionEvent e) {
	        	DefaultMutableTreeNode node = (DefaultMutableTreeNode) reqTree.getLastSelectedPathComponent();
		        if (node == null)
		        	return;
				Global.parosFrame.getParosMenu().setMenuScanSkipDisplay((ParsedEntity) node);
		  	}
	    });
      	
    }

    public void TreeRefresh(){
	    SwingUtilities.invokeLater(new Runnable() {
			public void run() {
                reqTree.removeAll();
                reqTree = new JTree(reqTreeRootNode);
                addTreeListener();
  
  //          jScrollPane2.getViewport().remove(reqTree);
                jScrollPane2.getViewport().add(reqTree, null);
          	}
      	});
    }

	public void setTree(HttpRequestHeader req, HttpBody body) throws HttpMalformedHeaderException, URISyntaxException {
		addPath(req, body);
		TreeRefresh();
	}

	/*
	public void setTree(String host, String uri){
		if (uri.startsWith("http://")){
        	uri = uri.substring( ("http://"+host).length(), uri.length());
        }


		addPath(reqTreeRootNode, host+"/"+uri, "");
		TreeRefresh();

    }
    */

	public void clearTree(){
	    reqTree.removeAll();
	    reqTreeRootNode = new ParsedEntity("Web Site Hierarchy");	//new DefaultMutableTreeNode("Web Site Hierarchy");
	    reqTree = new JTree(reqTreeRootNode);
	    addTreeListener();
  		jScrollPane2.getViewport().add(reqTree, null);
	}

	private void addChild(final DefaultMutableTreeNode parent, final DefaultMutableTreeNode child) {
		// should not use invokeLater here because to avoid adding multiple node by other thread.
		
		/*	used tree model so these code obsolete
		
		try {
			SwingUtilities.invokeAndWait(new Runnable() {
				public void run() {
					parent.add(child);
					child.setParent(parent);
				}
			});
		} catch (Exception e) {
		}
		*/
		
        treeModel.insertNodeInto(child, parent, parent.getChildCount());
	}

	private void removeChild(final DefaultMutableTreeNode child) {
		treeModel.removeNodeFromParent(child);
	}
	
	/**
	Add a HTTP request message to the tree.
	@param	reqHeader	The HTTP request header.
	@param	reqBody		The HTTP request body.
	*/
	public void addPath(HttpRequestHeader reqHeader, HttpBody reqBody) throws HttpMalformedHeaderException, URISyntaxException {

		ParsedURL parsedURL = new ParsedURL("", reqHeader, reqBody);	// caption to be set during display

		URI		uri			= parsedURL.getURIHostPath();
		String	absPath		= uri.getPath();
		String	baseUri		= "";

		baseUri = uri.getScheme() + "://" + parsedURL.getHostName();
		if (parsedURL.getHostPort() != 80 && parsedURL.getHostPort() != 443) {
			baseUri = baseUri + ":" + parsedURL.getHostPort();
		}

		ParsedEntity	parentEntity = null,
						curEntity		= null;
						
		// avoid multiple update to the tree
		synchronized (reqTreeRootNode) {
	
			try {
				parentEntity = findChild(reqTreeRootNode, parsedURL.getHostName());
				if (parentEntity == null) {
					parentEntity	= new ParsedFolder(parsedURL.getHostName(), new URI(baseUri), parsedURL);
					addChild(reqTreeRootNode, parentEntity);
				}

				Pattern pattern = Pattern.compile("/");
				String[] split = pattern.split(absPath);
				for (int i=0; i<split.length; i++) {
					String path = split[i];
					if (!path.equals("")) {
						curEntity = findChild(parentEntity, path);
						baseUri = baseUri + "/" + path;
						if (curEntity == null) {
							// node not found
							if (i < split.length-1) {
								// is folder
								curEntity	= new ParsedFolder(path, new URI(baseUri), parsedURL);
							} else {
								// leaf node;
								parsedURL.setCaption(path);
								curEntity		= parsedURL;
							}
							addChild(parentEntity, curEntity);
						} else {
							// node found.
							
							// replace content if this is a leaf.
							if (i == split.length-1) {
								//curEntity.setEntity(parsedURL.getRequestHeader(), parsedURL.getRequestBody());
								removeChild(curEntity);
								addChild(parentEntity, curEntity);
							}
							
						}

						parentEntity = curEntity;

					}
				}
			}
			catch (Exception e) {
				e.printStackTrace();
			}

		} // end sync

	}

	public void addPath(ParsedEntity parsedURL) throws HttpMalformedHeaderException, URISyntaxException {

		URI		uri			= parsedURL.getURIHostPath();
		String	absPath		= uri.getPath();
		String	baseUri		= "";

		baseUri = uri.getScheme() + "://" + parsedURL.getHostName();
		if (parsedURL.getHostPort() != 80 && parsedURL.getHostPort() != 443) {
			baseUri = baseUri + ":" + parsedURL.getHostPort();
		}
//		System.out.println(baseUri);
		ParsedEntity	parentEntity = null,
						curEntity		= null;
						
		// avoid multiple update to the tree
		synchronized (reqTreeRootNode) {
	
			try {
				parentEntity = findChild(reqTreeRootNode, parsedURL.getHostName());
				if (parentEntity == null) {
					parentEntity	= new ParsedFolder(parsedURL.getHostName(), new URI(baseUri), parsedURL);
					addChild(reqTreeRootNode, parentEntity);
				}

				Pattern pattern = Pattern.compile("/");
				String[] split = pattern.split(absPath);
				for (int i=0; i<split.length; i++) {
					String path = split[i];
					if (!path.equals("")) {
						curEntity = findChild(parentEntity, path);
						baseUri = baseUri + "/" + path;
						if (curEntity == null) {
							if (i < split.length-1) {
								// is folder
								curEntity	= new ParsedFolder(path, new URI(baseUri), parsedURL);
							} else {
								// leaf node;
								parsedURL.setCaption(path);
								curEntity		= parsedURL;
							}
							addChild(parentEntity, curEntity);
						} else {
							// node found.
						
							// replace content if this is a leaf.
							if (i == split.length-1) {
								//curEntity.setEntity(parsedURL.getRequestHeader(), parsedURL.getRequestBody());
								removeChild(curEntity);
								addChild(parentEntity, curEntity);
							}
						
						}
					
						parentEntity = curEntity;

					}
				}
			}
			catch (Exception e) {
				e.printStackTrace();
			}

		} // end sync

	}



	/**
	Find a immediate child under the parent matching the caption.
	@param	parent	Parent node to be searched.
	@param	caption	Caption for searching.
	@return	The child node under the parent matching the caption.  Null = not found.
	*/	
	private ParsedEntity findChild(DefaultMutableTreeNode parent, String caption) {
		for (int i=0; i<parent.getChildCount(); i++) {
			ParsedEntity child = (ParsedEntity) parent.getChildAt(i);
			if (child.toString().equals(caption)) {
				return child;
			}
		}
		return null;
	}

	/**
	In-order traverse of tree starting from root.  For debug use only.
	*/
	public void debugTraverseTreeRoot() {
		debugTraverseTree(reqTreeRootNode);
	}

	/**
	In-order traverse of tree.  For debug use only.
	*/
	public void debugTraverseTree(DefaultMutableTreeNode node) {
		
		ParsedEntity en = null;
		if (node instanceof ParsedFolder) {
			en = (ParsedFolder) node;
			Util.showDebugMsg("Folder: " + en.getURIHostPath());
		} else if (node instanceof ParsedURL) {
			en = (ParsedURL) node;
			Util.showDebugMsg("URL: " + en.getURIHostPath());
		}			

		for (int i=0; i<node.getChildCount(); i++) {
			debugTraverseTree((DefaultMutableTreeNode) node.getChildAt(i));
		}
	}

	public DefaultTreeModel getTreeModel() {
		return treeModel;
	}
	
	public JTree getTree() {
		return reqTree;
	}

}