/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.util;


public class ThreadPool {


	private Thread[]	mThreadPool		= null;
	
	public ThreadPool(int maxThreadCount) {
		mThreadPool		= new Thread[maxThreadCount];
	}

	/**
	Get a free thread from thread pool.  If there is no free thread, wait until get one free.
	*/
	public Thread getFreeThread(Runnable r) {
		while (true) {
			for (int i=0; i<mThreadPool.length; i++) {
				if (mThreadPool[i] == null || !mThreadPool[i].isAlive()) {
					mThreadPool[i] = new Thread(r);
					return mThreadPool[i];
				}
			}

			Util.sleep(30);
		}
	}

	/**
	Wait until all thread completed tasks (at most 20s for each).
	If not completed yet, do not wait.  Each thread should kill itself.
	*/
	public void waitAllThreadComplete(int waitInMillis) {
		for (int i=0; i<mThreadPool.length; i++) {
			if (mThreadPool[i] != null && mThreadPool[i].isAlive()) {
				try {
					mThreadPool[i].join(waitInMillis);
				} catch (InterruptedException e) {
				}
			}
		}
	}

}

