/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;


import javax.swing.JOptionPane;

import com.proofsecure.paros.Global;

public final class Util{


	/**
	Sleep with the number of milliseconds.
	@param ms	Number of milliseconds.
	*/
	public static void sleep(int ms) {
    	try {
        	Thread.sleep(ms);
		} catch (InterruptedException e) {
		}
	}

	/**
	Close the socket with exception catched.
	@param	socket	Socket to be closed.
	*/
	public static void closeSocket(Socket socket) {
    	if (socket == null) {
        	return;
        }
		
		try {
        	socket.close();
		} catch (Exception e) {
		}
		
        socket = null;
	}
	
	/**
	Close the socket with exception catched.
	@param	socket	Socket to be closed.
	*/
	public static void closeServerSocket(ServerSocket socket) {
    	if (socket == null) {
        	return;
        }
		
		try {
        	socket.close();
		} catch (Exception e) {
		}
		
        socket = null;
	}
	

	/**
	Close the input stream with all exception catched.
	@param in InputStream to be closed.
	*/		
	public static void closeInputStream(InputStream in) {
		try {
			in.close();
		} catch (Exception e) {
		}
	}

	/**
	Close the output stream with all exception catched.
	@param out	OutputStream to be closed.
	*/	
	public static void closeOutputStream(OutputStream out) {
		try {
			out.close();
		} catch (Exception e) {
		}
	}
		

	/**
	Extract the path and query portion from the URI given.
	Eg "http://www.testinghost.com/testingpath/abc?def=123
	This will return /testingpath/abc?def=123
	@param	uri URI to be extracted.
	@return	String The path + query part.
	*/
	public static String getURIPathQuery(URI uri) {
		
		String result = uri.getPath();
		if (result != null && result.equals("")) {
			result = "/";
		}
		if (uri.getQuery() != null) {
			result = result + "?" + uri.getQuery();
		}
		return result;
	}

	public static String getURIHostPath(URI uri, boolean isSecure) {

		if (uri.getScheme().equalsIgnoreCase("https")) {
			isSecure = true;
		}
		
		String hostAndPath	= "";
		if (isSecure) {
			hostAndPath = "https://" + uri.getHost();
			// port == -1 means port undefined
			if (uri.getPort() != -1 && uri.getPort() != 443) {
				hostAndPath = hostAndPath + ":" + uri.getPort();
			}
		} else {
			hostAndPath	= "http://" + uri.getHost();
			if (uri.getPort() != -1 && uri.getPort() != 80) {
				hostAndPath = hostAndPath + ":" + uri.getPort();
			}
		}
		
		String path = uri.getPath();
		if (path != null) {
			if (path.equals("")) {
				path = "/";
			}
			hostAndPath			= hostAndPath + uri.getPath();
		}

		return hostAndPath;
	}
	
	
	public static void showDebugMsg(String msg) {
		System.out.println(msg);
	}

	/**
	Socket connect to the designated host and port, via proxy if required.
	*/
	public static Socket connect(String hostName, int hostPort, boolean isSecure) throws IOException {
		Socket socket = null;
		
		if (isSecure) {
			if (checkAndUseProxy(hostName)) {
				try{
					socket = Global.ssl.clientViaProxy(hostName, hostPort, Global.config.getProxyChainName(), Global.config.getProxyChainPort(), Global.isUseClientCert);
 				} catch (SocketException e) {
					socket = Global.ssl.client(hostName, hostPort, Global.isUseClientCert);
 				}

			} else {
				socket = Global.ssl.client(hostName, hostPort, Global.isUseClientCert);
			}
		} else {
			if (checkAndUseProxy(hostName)) {
				try {
					socket = new Socket(Global.config.getProxyChainName(), Global.config.getProxyChainPort());
	            }
	            catch (SocketException e){
	                socket = new Socket(hostName, hostPort);                		
	            }
	        } else {
				socket = new Socket(hostName, hostPort);
			}
		}
		
		return socket;

		
			
	}
	
	public static boolean checkAndUseProxy(String hostName) {
		return Global.config.useProxy(hostName);
	}
	
	public static void beep() {
		java.awt.Toolkit.getDefaultToolkit().beep();
	}
	
	public static void showMessageDialog(String text) {
		JOptionPane.showMessageDialog(Global.parosFrame, text, Global.APP_TITLE, JOptionPane.WARNING_MESSAGE);		
	}
		
	public static void showConfirmDialog(String text) {
		JOptionPane.showConfirmDialog(Global.parosFrame, text, Global.APP_TITLE, JOptionPane.YES_NO_OPTION);		
	}
	
	public static void writeStatus(String text) {
		Global.parosFrame.setStatus(text);
	}
	
	public static void writeOutput(String text) {
		
		if (Global.isRunGUI) {
			if (!text.endsWith("\r\n")) {
				text = text + "\r\n";
			}
			Global.parosFrame.logAppend(text);
		} else {
			writeConsole(text);
		}
	}
	
	public static void writeConsole(String text) {
		System.out.println(text);
	}

	public static void centreChild(javax.swing.JFrame parent, Component child) {
		Dimension parentSize = parent.getSize();
    	Dimension childSize = child.getPreferredSize();
    	Point loc = parent.getLocation();
    	child.setLocation((parentSize.width - childSize.width) / 2 + loc.x, (parentSize.height - childSize.height) / 2 + loc.y);
	}
	

	
	
	

		



}