/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class FunctionManager { //extends Thread implements HeaderFilter{
 protected final String[] headerName = {"Enable", "Function", "Description"};
 protected Boolean defaultStatus = new Boolean(true); 

 protected Hashtable items = new Hashtable ();  // Hashtable is thread-safe
 protected Vector enablelist = new Vector();

 // used for dynamic loading of filters	
 private String path = ".//"; 
 private String cpath = ""; 
 private String classtype = ".class"; 
  


 public FunctionManager(){
   init();    
   createList();
 }
 

 public abstract void createList();
 
 
 public Enumeration getNames(){
    Enumeration v = items.keys();
    return v;
  }

 public Vector getDataModel(){
    return enablelist;
 }

 public Hashtable getHashtable(){
    return items;
 }

 public String[] getHeaderName(){
    return headerName;
 }

  /**
      init the ScanManager, which is called once (static) in ProxyHandler
      @param  
      @return
  */
  protected abstract void init();


  /**
      init the ScanManager, which is called once (static) in ProxyHandler
      @param  
      @return
  */

  protected void initDynamic(String p, String cp, String ct){     
    path = p;
    cpath = cp;
    classtype = ct;
  	
    File dir = new File(path);
    
    
    FilenameFilter filter = new FilenameFilter() {
        public boolean accept(File dir, String name) {
          return (name.endsWith(classtype) && !(new File(path+name)).isDirectory());
        }
    };
    String[] children = dir.list(filter);
             
    if (children != null) { 
        // if there are items in the directory
      File file = new File(path);        
      try {
          // Convert File to a URL
          URL url = file.toURL();          // file:/c:/myclasses/
          URL[] urls = new URL[]{url};
      
          // Create a new class loader with the directory
          ClassLoader cl = new URLClassLoader(urls);
      
          // Load in the class; 
          for (int i=0; i<children.length; i++) {
            Class cls = cl.loadClass(cpath + children[i].substring(0,children[i].indexOf(classtype)));
                       
          // only print and add class with HeaderFilter/BodyFilter interface to table
            if (isFilter(cls)){
              items.put(children[i].substring(0,children[i].indexOf(classtype)), cls.newInstance());
//              System.out.println(children[i].substring(0,children[i].indexOf(classtype)) + " " + items.size());
            }
              
          }        
      
      } catch (MalformedURLException e) {
      } catch (ClassNotFoundException e) {
      } catch (IllegalAccessException e) {
      } catch (InstantiationException e) {
      }

    } else {
        // Either dir does not exist or is not a directory
    }
  }


  /**
      Called by proxyHandler to filter each HTTP request/response headers
      @param  header  header to be filtered
      @param  body		body to be filtered
      @param  
  */
  void process(){};

  /**
      check if the filter has interface HeaderFilter
      @param  cls   class of the filter
      @return yes or no
   */
  protected abstract boolean isFilter(Class cls);
  
}



 
