/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros;
 
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

import com.proofsecure.paros.network.SSLConnector;
import com.proofsecure.paros.ui.LicenseFrame;
import com.proofsecure.paros.ui.ParosFrame;
import com.proofsecure.paros.ui.TrapPanel;
import com.proofsecure.paros.ui.TreePanel;
import com.proofsecure.paros.util.Util;


public class Paros {

	private static final String PARAM_TUNNEL 	= "-tunnel";
	private static final String PARAM_SSL_IN	= "-sslin";
	private static final String PARAM_SSL_OUT	= "-sslout";
	private static final String PARAM_NOUSERAGENT1 = "-noUserAgent";
	private static final String PARAM_NOUSERAGENT2 = "-u";
	private static final String PARAM_HELP1		= "-help";
	private static final String PARAM_HELP2		= "-h";
	private static final String PARAM_SOURCE	= "-source";
	
  private boolean packFrame = false;
  private ParosFrame frame = null;
  //Construct the application
  public Paros(ParosFrame frame) {
  		
    this.frame = frame;
//    frame = new ParosFrame();
    //Validate frames that have preset sizes
    //Pack frames that have useful preferred size info, e.g. from their layout
    if (packFrame) {
      frame.pack();
    }
    else {
      frame.validate();
    }
    //Center the window
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = frame.getSize();
    if (frameSize.height > screenSize.height) {
      frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width) {
      frameSize.width = screenSize.width;
    }
    frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    frame.setVisible(true);

//    frame.setStatus("Initiating...");
  }

  private ParosFrame getFrame(){
    return frame;
  }

	private static void showLicense(){
    if (!(new File("AcceptedLicense")).exists()){
      
      LicenseFrame license = new LicenseFrame();
      license.showFrame();
	  	 	 
      while (license.isAcceptLicense() == false){
        Util.sleep(100);
      }

//      Tools.acceptedEULA();
      try{
         FileWriter fo = new FileWriter("AcceptedLicense");
         fo.close();
      }catch (IOException ie){
        JOptionPane.showMessageDialog(new JFrame(), "Unknown Error. Please report to the author.");
        System.exit(0);
      }

    }
	}

	//Main method
  	public static void main(String[] args) throws Exception {
  
		if (args.length > 0) {
			try {
				if (!parseOptions(args)) {
					throw new Exception();
				}
		 
			} catch (Exception e) {
				writeConsole("Invalid parameters.");
				displayHelp();
				System.exit(1);
			}
		}
	
  		Locale.setDefault(Locale.ENGLISH);

		System.setProperty("java.protocol.handler.pkgs","com.sun.net.ssl.internal.www.protocol");
		java.security.Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());

		if (Global.isRunGUI) {
    		try {
      			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    		}
		    catch(Exception e) {
      			e.printStackTrace();
    		}

			Global.splash.start();
			initGlobalData();
			initUI();
			//Global.scanner.listAllAlert();
		} else {
			initGlobalData();
			initCommandLine();
			while (true) {
				Util.sleep(10000);
			}
		}
	}

  private static void initGlobalData() throws Exception {


	Global.ssl 		= new SSLConnector();
  Global.filterManager = new FilterManager();
//    Global.testManager = new paros.TestManager();
  Global.scanManager = new com.proofsecure.paros.scan.ScanManager();
  Global.config = new com.proofsecure.paros.util.Config();
	Global.proxy   = null;
	Global.SSLProxy	= null;
	Global.adminServer = null;
	Global.parosFrame = null;
	Global.treePanel	= new TreePanel();
	Global.trapPanel	= new TrapPanel();
	Global.scanner = new com.proofsecure.paros.scan.Scanner(); 	
	Global.webDoc =  new com.proofsecure.paros.document.WebDoc();
	Global.findDialog 		= null;  	
	Global.ssl.init();
	
  	
  }

	private static void initCommandLine() {

		boolean success = true;
		try {
			Global.config.read(com.proofsecure.paros.ui.OptionPanel.FILE_OPTION);
		} catch (Exception e) {
		}
		
		if (!success) {
			return;
		}

		if (Global.isCmdSSLin) {
			Global.SSLProxy = new SSLProxy("localhost", Global.cmdSourcePort);
    		success = true;
    		if ((success = Global.SSLProxy.startServer()) == false) {
      			writeConsole("Error tunnel initialization, please exit.");
      			System.exit(1);
    		}			
		}
		else {
		    Global.proxy = new Proxy("localhost", Global.cmdSourcePort);
    		success = true;
    		if ((success = Global.proxy.startServer()) == false) {
      			writeConsole("Error tunnel initialization, please exit.");
      			System.exit(1);
    		}
	    }
	    	
		writeConsole("Tunneling = " + Global.cmdHostName + ":" + Global.cmdHostPort);
		writeConsole("Source port = " + Global.cmdSourcePort); 

	 }

	private static void initUI() {
    
		showLicense();

		//    proxyH.initFrame(frame) ;
    	Global.parosFrame = new ParosFrame();	

	    Paros proxyH = new Paros(Global.parosFrame);
	    ParosFrame mframe = proxyH.getFrame();

//		System.out.println("paros1 " + System.currentTimeMillis());	

		boolean success = false;
		/*
		boolean success = false;
		try {
			Config.read("Options.xml");
			success = true;
		} catch (Exception e) {
			mframe.setStatus("Unable to read Options.xml, please check.");
		}
		*/
		success = true;
		
		if (success) {
		    Global.proxy = new Proxy(Global.config.getProxyIP(), Global.config.getProxyPort());
	    	success = true;
	    	if ((success = Global.proxy.startServer()) == false) {
	      		mframe.setStatus("Error proxy server initialization, please exit.");
	    	}
	    }
	
	    if (success) {
		    mframe.setStatus("Please wait...");

		    Global.SSLProxy = new SSLProxy(Global.config.getProxyIP(), Global.config.getProxyPortSSL());
		    if ((success = Global.SSLProxy.startServer()) == false) {
		    	mframe.setStatus("Error SSL proxy server initialization, please exit");
			}
	    }
	
	    if (success && Global.isRunAdminServer) {
			Global.adminServer = new AdminServer(AdminServer.ADMIN_SERVER_NAME, AdminServer.ADMIN_SERVER_PORT);		
		    if ((success = Global.adminServer.startServer()) == false) {
		      mframe.setStatus("Error Admin server initialization, please exit");
		    }
		}
        
  
	
	    if (success) {
	      mframe.setStatus("Ready");
	    }

		Global.splash.cleanup();
	}

	private static void displayHelp() {
		String CRLF = "\r\n";
		String help =
			"Usage:\tjava -jar paros.jar [-tunnel dest_host:port [-sslin] [-sslout]] [-source this_host:port] [-help]" + CRLF + CRLF +
			"\t" + PARAM_TUNNEL + ":\t" + "destination host and port to tunnel, use proxy in configuration." + CRLF +
			"\t" + PARAM_SSL_IN + ":\t\t" + "enable ssl tunnelling input." + CRLF +
			"\t" + PARAM_SSL_OUT + ":\t" + "enable ssl tunnelling output." + CRLF +
			"\t" + PARAM_SOURCE + ":\t" + "local source server and port for tunnel." + CRLF +
			"\t" + PARAM_HELP1 +"|" + PARAM_HELP2 + ":\t" + "display this help screen." + CRLF +
			"Example: java -jar paros.jar -tunnel www.any_host.com:443 -sslout -source localhost:80" + CRLF +
			"then try telnet to localhost:80" + CRLF;
		
		writeConsole(help);		
	}
	
	private static boolean parseOptions(String args[]) throws Exception {
		
		//Pattern patternHost	= Pattern.compile("(\\w+):(\\d+)");
		int pos = 0;
		String sHost = null;
		
    	for (int i=0; i<args.length; i++) {
    		if (args[i] == null) {
    			continue;
    		}
    		
    		if (args[i].equalsIgnoreCase(PARAM_NOUSERAGENT1) || args[i].equalsIgnoreCase(PARAM_NOUSERAGENT2)) {
    			Global.isModifyUserAgent = false;
    			args[i] = null;
    		} else if (args[i].equalsIgnoreCase(PARAM_TUNNEL)) {
    			Global.isCmdTunnel = true;
    			args[i] = null;
				Global.isRunGUI = false;

				pos = 0;
				sHost = args[i+1];
				if ((pos = sHost.indexOf(':', 2)) > -1) {
					Global.cmdHostName = sHost.substring(0,pos).trim();
					Global.cmdHostPort = Integer.parseInt(sHost.substring(pos+1));
				} else {
					return false;
				}
				args[i+1] = null;
			} else if (args[i].equalsIgnoreCase(PARAM_SSL_OUT)) {
				Global.isCmdSSLout = true;
				args[i] = null;
			} else if (args[i].equalsIgnoreCase(PARAM_SSL_IN)) {
				Global.isCmdSSLin = true;
				args[i] = null;
			} else if (args[i].equalsIgnoreCase(PARAM_SOURCE)) {
				//Global.cmdSourcePort = Integer.parseInt(args[i+1]);
				//args[i] = null;
				//args[i+1] = null;
				
				args[i] = null;				
				pos = 0;
				sHost = args[i+1];
				if ((pos = sHost.indexOf(':', 2)) > -1) {
					Global.cmdSourceHost = sHost.substring(0,pos).trim();
					Global.cmdSourcePort = Integer.parseInt(sHost.substring(pos+1));
				} else {
					return false;
				}
				args[i+1] = null;
    		} else if (args[i].equalsIgnoreCase(PARAM_HELP1) || args[i].equalsIgnoreCase(PARAM_HELP2)) {
				Global.isRunGUI = false;
			 	displayHelp();
			 	System.exit(0);
			} else if (args[i].equalsIgnoreCase("-st")) {
				args[i] = null;
				Global.isST = true;
			}

    	}
    	
    	for (int i=0; i<args.length; i++) {
    		if (args[i] != null) {
    			return false;
    		}
    	}
    	
    	return true;
    }

	private static void writeConsole(String s) {
		System.out.println(s);
	}

}
