/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

import com.proofsecure.paros.util.Util;


public class Proxy implements Runnable {

	protected final static int PORT_TIME_OUT = 3000;
	protected ServerSocket mProxySock = null;
	protected String mProxyIP = null;
	protected int mProxyPort = 0;
	protected boolean mIsProxyRunning = false;
	protected boolean mIsExit = false;
	Thread myThread = null;
	
	public Proxy(String proxyIP, int port) {
		mProxyIP	= proxyIP;
		mProxyPort	= port;
	}

	public synchronized boolean startServer() {
		
		if (mIsProxyRunning) {
			return false;
		}

		Util.closeServerSocket(mProxySock);

		mIsProxyRunning	= false;
		mIsExit			= false;

        myThread = new Thread(this);
        myThread.setDaemon(true);
   	    myThread.setPriority(Thread.NORM_PRIORITY + 1);
		myThread.start();

		try {
			
			if (Global.isCmdTunnel) {
				//mProxySock = new ServerSocket(Global.cmdSourcePort, 300, InetAddress.getByName(Global.config.getProxyIP()));
				mProxySock = new ServerSocket(Global.cmdSourcePort, 300, InetAddress.getByName(Global.cmdSourceHost));
			} else {
				mProxySock = new ServerSocket(mProxyPort, 300, InetAddress.getByName(mProxyIP));
			}
			mProxySock.setSoTimeout(PORT_TIME_OUT);
			mIsProxyRunning = true;

		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
		Util.writeOutput("Proxy server started.");

		return true;
	}

	public synchronized boolean stopServer(){
		String stopMsg = "Proxy server stopped.";
		if (this instanceof SSLProxy) {
			stopMsg = "SSL proxy server stopped.";
		}
			

		if (!mIsProxyRunning) {
			Util.writeOutput(stopMsg + "(already stopped)");
			return true;
		}

		mIsProxyRunning = false;
		mIsExit = true;

		try {
			myThread.join();
		} catch (Exception e) {
			e.printStackTrace();
		}

		Util.closeServerSocket(mProxySock);
		
		mProxySock = null;
		Util.writeOutput(stopMsg);
		return true;
	}

	public void run() {

		Socket clientSock = null;
		ProxyHandler p = null;

		while (!mIsExit) {

			try {
				if (mIsProxyRunning) {
					clientSock = mProxySock.accept();
					if (Global.isCmdTunnel) {
						if (Global.isCmdSSLout) {
							p = new ProxyPassThruHandler();
						} else {
							p = new ProxyPortForwardHandler();
						}
					} else {
						p = new ProxyHandler();
					}

					p.start(clientSock);
				} else {
					Util.sleep(100);
				}
			} catch (Exception e) {
			}
		}


	}


}
