/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros;
 
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import java.net.SocketTimeoutException;

import com.proofsecure.paros.network.HttpConnection;
import com.proofsecure.paros.network.HttpConnectionPool;
import com.proofsecure.paros.network.HttpInputStream;
import com.proofsecure.paros.network.HttpOutputStream;
import com.proofsecure.paros.network.HttpResponseHeader;
import com.proofsecure.paros.util.Util;

class ProxyPassThruHandler extends ProxyHandler {


	ProxyPassThruHandler() {
		super();
	}

	/**
	Main process method in Run()
	*/
	protected void process() {
		processPassThru(Global.cmdHostName, Global.cmdHostPort, Global.isCmdSSLout);
	}

	/**
	Handler for pass through
	*/
	private void processPassThru(String hostName, int hostPort, boolean isSecure) {

		HttpResponseHeader res = new HttpResponseHeader();
		int len = 0;
		byte[] buf = new byte[BUFFEREDSTREAM_SIZE];
		long lastTime = 0;
		BufferedInputStream	proxy_in = null;
		BufferedOutputStream proxy_out = null;
		HttpOutputStream passthru_out = null;
		HttpInputStream passthru_in = null;
		HttpConnectionPool pool = new HttpConnectionPool(Global.config, Global.ssl);
		HttpConnection conn = null;
		
		try {
			proxy_in = new BufferedInputStream(mInSocket.getInputStream());
			proxy_out = new BufferedOutputStream(mInSocket.getOutputStream());

			conn = pool.connect(hostName, hostPort, isSecure, false);
			mOutSocket = conn.mSocket;
			passthru_out = conn.mHttpOut;
			passthru_in = conn.mHttpIn;

			do {

				// restrict reading count to give chance to read output
				
				for (int i=0; i<3 && available(mInSocket, proxy_in) > 0;i++) {
					len = proxy_in.read(buf);
					if (len > 0) {
						passthru_out.write(buf,0,len);
						passthru_out.flush();
						lastTime = System.currentTimeMillis();
					}
				}

				// switch to other thread as request just sent
				Thread.yield();
				
				for (int i=0; i<3 && passthru_in.available() > 0;i++) {
					len = passthru_in.read(buf);
					if (len > 0) {
						proxy_out.write(buf,0,len);
						proxy_out.flush();
						lastTime = System.currentTimeMillis();
					}
				}

				if (proxy_in.available() > 0 || passthru_in.available() > 0) {
					continue;
				}
				
				Util.sleep(20);

			} while (!mInSocket.isClosed() && !mOutSocket.isClosed()
					&& !mOutSocket.isInputShutdown() && !mInSocket.isInputShutdown()
					);	//&& System.currentTimeMillis() < lastTime + 300000);

		} catch (Exception e) {
			//e.printStackTrace();
		}

		Util.closeInputStream(proxy_in);
		Util.closeOutputStream(proxy_out);
		passthru_in.close();
		passthru_out.close();

		pool.close();
	}

	public int available(Socket sock, BufferedInputStream in) throws IOException {
		int avail = 0;
		int oneByte = -1;
		int timeout = 0;
		avail = in.available();
		if (avail == 0 && sock != null && sock instanceof SSLSocket) {
			try {
				timeout = sock.getSoTimeout();
				sock.setSoTimeout(3);
				in.mark(256);
				oneByte = in.read();
				in.reset();
				avail = in.available();
			} catch (SocketTimeoutException e) {
				avail = 0;
			} finally {
				sock.setSoTimeout(timeout);
			}
		}
		
		return avail;
	}

}



