/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros;


// java packages used
import java.net.InetAddress;
import java.net.Socket;

import com.proofsecure.paros.util.Util;


public class SSLProxy extends Proxy {

	public SSLProxy(String proxyIP, int port) {
		super(proxyIP, port);
	}
	
	public synchronized boolean startServer() {
		
		if (mIsProxyRunning) {
			return false;
		}
		
		mIsProxyRunning	= false;
		mIsExit			= false;

		Util.closeServerSocket(mProxySock);
		
        myThread = new Thread(this);
        myThread.setDaemon(true);
   	    myThread.setPriority(Thread.NORM_PRIORITY + 1);
		myThread.start();

		try {
			mProxySock = Global.ssl.listen(mProxyPort, 300, InetAddress.getByName(mProxyIP));

	    	mProxySock.setSoTimeout(PORT_TIME_OUT);
			mIsProxyRunning = true;
			Util.writeOutput("SSL proxy server started.");


		} catch (Exception e) {
			System.out.println("Error: Cannot open proxy port.");
			return false;
		}
		
		return true;
	}

	public void run() {

		Socket clientSock = null;
		SSLProxyHandler p = null;
		
		while (!mIsExit) {

			try {
				if (mIsProxyRunning) {
					clientSock = mProxySock.accept();
					p = new SSLProxyHandler();
					p.start(clientSock);
				} else {
					Util.sleep(100);
				}
			} catch (Exception e) {
			}

		}


	}


}