/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros;
 
// java packages
import java.net.Socket;

import com.proofsecure.paros.network.HttpRequestHeader;

class SSLProxyHandler extends ProxyHandler {

	SSLProxyHandler() {
		super();
	}

	public void start(Socket sock) {
		mInSocket = sock;
		mOriginHandler = ProxyHandler.getOriginatingTunnelProcess(mInSocket.getPort());
		super.start(sock, true);

	}

	 protected void disconnect() {
	 	long startTime = System.currentTimeMillis();
	 	
		while (mOriginHandler!=null && !mOriginHandler.isTunnelInputBufferEmpty() && System.currentTimeMillis() - startTime < 7000) {
			Tools.sleep(50);
		}

		mOriginHandler.setDisconnect(true);

		try {
			mOriginHandler.getThread().join(4000);
		} catch (InterruptedException e) {
		}

		//startTime = System.currentTimeMillis();
		//while (mOriginHandler.isAlive() && System.currentTimeMillis() - startTime < 5000) {
		//	Tools.sleep(50);
		//}

		super.disconnect();

	}


	//protected void assumeProxy() {
	//	mClientHttpInReqHeader.setAbsoluteUriRequired(false);
	//}
	
	/**
	Process after request header is read.  Overriden by SSLProxyHandler.
	*/
	protected void afterRequestHeaderRead(HttpRequestHeader req) {
		req.setSecure(true);
		req.setHostName(mOriginHandler.mHostName);
		req.setHostPort(mOriginHandler.mHostPort);
	}


}