/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


package com.proofsecure.paros.document;

import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpHeader;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;


/* WebLink - contains request header, request body, response header and response body
 * 
 */

public class WebLink implements  java.io.Serializable {
	String host = null;
	String URL = null;  // first line of header
	HttpRequestHeader reqHeader = null;
	HttpBody reqContent = null;
	HttpResponseHeader respHeader = null;
	HttpBody respContent = null;
	boolean HttpsLink = false;
	
	public WebLink(){	
	}
	public WebLink(boolean flag, String s, HttpRequestHeader h, HttpBody c){	
		HttpsLink = flag;
		URL = s;
		reqHeader = h;
		host = reqHeader.getHostName();
		reqContent = c;	
	}
	
	public boolean isHttpsLink(){
		return HttpsLink;
	}
	
	public HttpHeader getReqHeader(){
		return reqHeader;
	}
	public HttpBody getReqContent(){
		return reqContent;
	}

	public void setRespHeader(HttpResponseHeader h){
		respHeader = h;
	}
	public void setRespContent(HttpBody c){
		respContent = c;
	}

	public HttpHeader getRespHeader(){
		return respHeader;
	}
	public HttpBody getRespContent(){
		return respContent;
	}
	
	public String getURL(){
		return URL;
	}
	public String getHost(){
		return host;
	}
	
}