/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.filter;

import java.util.Vector;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpRequestHeader;
                    
public class LogCookie extends AbstractFilter{
	private Vector cookies = null;
    
  public LogCookie(){
  		super();
  		dialog = new PDialog("LogCookie");
		cookies = new Vector();
  }

  /**
  *   used by FilterManager to run the filter 
  *   @param    header      header to be filtered
  *   @param    body 				body to be filtered (no use here)
  */
  public void filterRequest(HttpRequestHeader header, HttpBody body){
    if (header != null ) {
    	String cookie = header.getHeader("Cookie");
		synchronized (cookies){
			if (cookie != null && cookies.indexOf(cookie)==-1){           		
				HttpRequestHeader reqheader = (HttpRequestHeader)header;
				String uri = reqheader.getHostName(); //getAbsoluteURI();        
				cookies.add(cookie);
				Global.parosFrame.logAppend(com.proofsecure.paros.ui.ParosFrame.COOKIE_LOG, uri + "\t" + cookie +"\n");
			}
		}
    }
  }
  
  
  public void clearInternalStatus(){
	synchronized (cookies){
		cookies = new Vector();
	}
  }
  
  public String usage(){
    return "Log all cookies sent from browser to server";
  }    

  
}