/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.log;

import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.scan.ScannerOffline;
import com.proofsecure.paros.ui.FindDialog;
import com.proofsecure.paros.ui.TreePanel;
import com.proofsecure.paros.util.Util;

/**
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
class DumpFrame extends JFrame implements ListSelectionListener {
	//	Variables declaration - do not modify
	private static final int FRAME_HEIGHT = 480;
	private static final int FRAME_WIDTH = 640;
	public static final String FRAME_NAME = "Log Analyzer";
	private javax.swing.JPanel jPanel1;
	private javax.swing.JPanel jTopPanel;
	private javax.swing.JScrollPane jScrollPane1;
	private javax.swing.JScrollPane jScrollPane2;
	private javax.swing.JScrollPane jScrollPane3;
	private javax.swing.JScrollPane jScrollPane4;
	private javax.swing.JScrollPane jScrollPane5;
	private javax.swing.JScrollPane jTopScrollPane;
	private javax.swing.JSplitPane jSplitPane1;
	//	private javax.swing.JTabbedPane jTabbedPane1;
	private javax.swing.JTabbedPane jTabbedPane1;
	private javax.swing.JTree jTree1;
	private JList jList1 = new javax.swing.JList();
	private TreePanel treePanel = new TreePanel(); //
	private DumpAnalyzerGUI da;
	private DumpResponsePanel dumpRequestPanel = new DumpResponsePanel();
	private DumpResponsePanel dumpResponsePanel = new DumpResponsePanel();
	private JTextArea commentPanel = new JTextArea();
	private JTextArea scriptPanel = new JTextArea();
	private GrepDialog grepDialog = null;

	//	private BrowserPanel browser = new BrowserPanel(); 
	private Box box1 = Box.createHorizontalBox();
	private JButton btnRefresh = new JButton();
	private JButton btnClear = new JButton();
	private JButton btnScan = new JButton();
	private JButton btnFilterReq = new JButton();
	private JButton btnFilterResp = new JButton();
	private JButton btnGrep = new JButton();

	// menu definition
	private JMenuBar jMenuBar = new JMenuBar();
	private JMenu jMenuFile = new JMenu();
	private JMenuItem jMenuFileExit = new JMenuItem();
	private JMenu jMenuEdit = new JMenu();
	private JMenuItem jMenuEditFind = new JMenuItem();

	//	End of variables declaration
//	private Pattern scriptPattern = Pattern.compile("<script[^>]*>[^<]*(.*?)[^<]*</script>",Pattern.MULTILINE | Pattern.DOTALL| Pattern.CASE_INSENSITIVE);
	private Pattern slashPattern = Pattern.compile("^(.*?[;]+| *)//.*$",Pattern.MULTILINE);
	private Pattern slashStarPattern = Pattern.compile("/[*].*?[*]/",Pattern.MULTILINE | Pattern.DOTALL);
	private Pattern scriptPattern = Pattern.compile("<script[^>]*>(.*?)</script>",Pattern.MULTILINE | Pattern.DOTALL| Pattern.CASE_INSENSITIVE);
	private Pattern commentPattern = Pattern.compile("<!--.*?-->", Pattern.MULTILINE | Pattern.DOTALL);
	private String COMMENT_BREAK = "\r\n=========================================================================\r\n";
	/**
	 * 
	 */
	public DumpFrame(DumpAnalyzerGUI d, DefaultListModel m) {
		da = d;
		setListModel(m);
		initComponents();
	}
	/**
	 * @param req
	 */

	public void setRequest(Vector r) {
		dumpRequestPanel.setMessage(r.get(0).toString(), r.get(1).toString());

	}

	public void setResponse(Vector r) {
		dumpResponsePanel.setMessage(r.get(0).toString(), r.get(1).toString());

	}

	public void setComment(String body) {
		if (body == null) {
			commentPanel.setText("");
			scriptPanel.setText("");
			return;
		}
		String comment = "";

		// check pattern <script..> ... </script> 
		Matcher matcher = scriptPattern.matcher(body);
		String scripts = "";
		while (matcher.find()){
			scripts += matcher.group(0) + COMMENT_BREAK;
		}

		// check <!-- .. --> comments
		matcher = commentPattern.matcher(body);	
		while (matcher.find()){			
			String m = matcher.group(0);
			if (scripts.indexOf(m)==-1){
				comment += m + COMMENT_BREAK;
			}
		}

		// check the '//' comments
		matcher = slashPattern.matcher(body);	
		while (matcher.find()){
			String m = matcher.group(0);
			if (scripts.indexOf(m)==-1){
				comment += m + COMMENT_BREAK;
			}
		}

		// check /* .. */ pattern		
		matcher = slashStarPattern.matcher(body);	
		while (matcher.find()){
			String m = matcher.group(0);
			if (scripts.indexOf(m)==-1){
				comment += m + COMMENT_BREAK;
			}
		}

		if (comment != null && !comment.equals("")) {
			commentPanel.setText(comment);
		}
		else
			commentPanel.setText("");
		
		if (scripts != null && !scripts.equals("")) {
			scriptPanel.setText(scripts);
		}
		else
			scriptPanel.setText("");
	}


	/*
	public DumpFrame(DefaultListModel m) {
		setListModel(m);
		initComponents();
	}
	*/
	public void showGUI() {
		/*
		if (Global.treePanel != null)
			treePanel.init(new JTree(Global.treePanel.getTreeModel()));
			*/
		initDisplay();
		if (!da.isCurSession()) {
			// check if the log is current session or saved log file
			//			btnRefresh.setVisible(false);
			//			btnScan.setVisible(false);
			btnClear.setVisible(false);
		}
		if (Global.isST)
			btnGrep.setVisible(true);
		else
			btnGrep.setVisible(false);
		setVisible(true);
		show();
	}

	private void initDisplay() {

		boolean packFrame = false;

		//Validate frames that have preset sizes
		//Pack frames that have useful preferred size info, e.g. from their layout
		initMenu();
		if (packFrame) {
			pack();
		} else {
			validate();
		}

		//Center the window
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension frameSize = getSize();
		if (frameSize.height > screenSize.height) {
			frameSize.height = screenSize.height;
		}
		if (frameSize.width > screenSize.width) {
			frameSize.width = screenSize.width;
		}
		setLocation(
			(screenSize.width - frameSize.width) / 2 + 20,
			(screenSize.height - frameSize.height) / 2 + 20);
		//		frame.setVisible(true);

	}

	private void initComponents() {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}

		setIconImage(Toolkit.getDefaultToolkit().createImage("paros_logo.gif"));
		//setIconImage(Toolkit.getDefaultToolkit().createImage(Frame2.class.getResource("[Your Icon]")));
		this.setSize(new Dimension(FRAME_WIDTH, FRAME_HEIGHT));
		this.setTitle(FRAME_NAME);

		jSplitPane1 = new javax.swing.JSplitPane();
		jSplitPane1.setBorder(BorderFactory.createEtchedBorder());
		jSplitPane1.setDividerSize(3);
		jScrollPane1 = new javax.swing.JScrollPane();
		jTree1 = new javax.swing.JTree();
		jTabbedPane1 = new javax.swing.JTabbedPane();
		//jTabbedPane1.setSize(new Dimension(400, 400));
		jPanel1 = new javax.swing.JPanel();
		jScrollPane2 = new javax.swing.JScrollPane();
		jScrollPane3 = new javax.swing.JScrollPane();
		jScrollPane4 = new javax.swing.JScrollPane();
		jScrollPane5 = new javax.swing.JScrollPane();
		jTopPanel = new javax.swing.JPanel();
		jTopPanel.setPreferredSize(new Dimension(400, 160));
		jTopScrollPane = new javax.swing.JScrollPane();
		commentPanel.setBackground(SystemColor.activeCaptionBorder);
		scriptPanel.setBackground(SystemColor.activeCaptionBorder);

		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent evt) {
				exitForm(evt);
			}
		});

		btnRefresh.setText("Refresh");
		btnRefresh.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				//jList1.clearSelection();
				jList1.setEnabled(false);
				da.refresh();
				jList1.setEnabled(true);
			}
		});

		btnClear.setText("Clear");
		btnClear.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				//jList1.clearSelection();
				int answer =
					JOptionPane.showConfirmDialog(
						null,
						"Clear the list?\r\n(this only affects the list display. Messages are still in session file)",
						"Warning",
						JOptionPane.YES_NO_OPTION);
				if (answer != JOptionPane.YES_OPTION) {
					// User clicked no
					return;
				}

				jList1.setEnabled(false);
				da.getDump().resetCurDate();
				da.refresh();
				Global.urlLog.clear();
				jList1.setEnabled(true);
			}
		});

		btnScan.setText("Offline Scan");
		btnScan.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int answer =
					JOptionPane.showConfirmDialog(
						null,
						"This function will only perform the check \"TestCacheAndMisc\" on the log, i.e. no real scan checks sent to the server.\r\nThe result may not be accurate due to reasons such as 304 response (instead of 200 OK) being saved in the file.\r\nContinue?",
						"Information",
						JOptionPane.YES_NO_OPTION);
				if (answer != JOptionPane.YES_OPTION) {
					// User clicked no
					return;
				}
				Thread thread = new ScanThread();
				thread.start();
			}
		});

		btnFilterReq.setText("Filter Requests");
		btnFilterReq.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				btnFilterActionPerformed(e, "request");

			}
		});

		btnFilterResp.setText("Filter Responses");
		btnFilterResp.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				btnFilterActionPerformed(e, "response");

			}
		});

		btnGrep.setText("Extract");		
		btnGrep.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (grepDialog==null)
					grepDialog = new GrepDialog(null, true, da);
				grepDialog.show();
			}
		});

		box1.add(btnRefresh, null);
		box1.add(btnClear, null);
		box1.add(btnFilterReq, null);
		box1.add(btnFilterResp, null);
		box1.add(btnScan, null);
		box1.add(btnGrep, null);
		jScrollPane3.setVerticalScrollBarPolicy(
			JScrollPane.VERTICAL_SCROLLBAR_NEVER);
		jScrollPane3.setHorizontalScrollBarPolicy(
			JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		jScrollPane3.getViewport().add(box1, null);

		//		jSplitPane1.setDividerLocation(FRAME_WIDTH/3);
		jSplitPane1.setDividerLocation(0);
		//jScrollPane1.setViewportView(jTree1);
		jList1.setFont(new java.awt.Font("Dialog", 0, 10));
		//jScrollPane1.setViewportView(jList1);

		//jSplitPane1.setLeftComponent(jScrollPane1);
		//		jSplitPane1.setLeftComponent(treePanel);
		jTopScrollPane.setViewportView(jList1);

		jPanel1.setLayout(new java.awt.BorderLayout());
		jPanel1.add(jScrollPane2, java.awt.BorderLayout.CENTER);
		jTopPanel.setLayout(new java.awt.BorderLayout());
		jTopPanel.add(jTopScrollPane, java.awt.BorderLayout.CENTER);
		jTabbedPane1.addTab("Request", dumpRequestPanel);
		jTabbedPane1.addTab("Response", dumpResponsePanel);
		jTabbedPane1.addTab("Comment", jScrollPane4);
		jTabbedPane1.addTab("Script", jScrollPane5);
		jScrollPane4.setViewportView(commentPanel);
		jScrollPane5.setViewportView(scriptPanel);
		
		jTabbedPane1.addMouseListener(new MouseAdapter() {
			public void mousePressed (MouseEvent e) {
				super.mousePressed(e);
				if (jList1.getSelectedValue()==null)
					return;
				String selected = (String) jList1.getSelectedValue();
				selected = selected.substring(0, selected.indexOf("---"));

				Vector result = null;
				if (jTabbedPane1.getSelectedIndex()
					== jTabbedPane1.indexOfTab("Request")) {
					result = da.searchRequest(selected);
					if (result != null) {
						setRequest(result);
					}

				} else if (
					jTabbedPane1.getSelectedIndex()
						== jTabbedPane1.indexOfTab("Response")) {

					result = da.searchResponse(selected);
					if (result != null) {
						setResponse(result);
						//				browser.show("text/html",(String)result.get(1));
					} else {
						result = new Vector(2);
						result.add(
							"Data with id "
								+ selected
								+ " not found.  Maybe due to response timeout or conection closed.");
						result.add(
							"Data with id "
								+ selected
								+ " not found.  Maybe due to response timeout or conection closed.");
						setResponse(result);
						// clean up the response header/body
					}
				} else if (
					jTabbedPane1.getSelectedIndex()
						== jTabbedPane1.indexOfTab("Comment") ||
					jTabbedPane1.getSelectedIndex()
						== jTabbedPane1.indexOfTab("Script")) {

					result = da.searchResponse(selected);
					if (result != null) {
						setComment(result.get(1).toString());
					} else
						setComment(null);
				}
		
			}
			});	
		//		jTabbedPane1.addTab("HTML Response", browser);
		//		jTabbedPane1.addTab("Request", jPanel1);

		//		jSplitPane1.setRightComponent(jTabbedPane1);

		this.getContentPane().add(jTabbedPane1, java.awt.BorderLayout.CENTER);
		this.getContentPane().add(jTopPanel, java.awt.BorderLayout.NORTH);
		this.getContentPane().add(jScrollPane3, java.awt.BorderLayout.SOUTH);

		jList1.addListSelectionListener(this);

		//		pack();
	}

	private void btnFilterActionPerformed(ActionEvent e, String searchPlace) {
		// TODO Auto-generated method stub
		JDialog dialog = new FilterDialog(this, true, searchPlace);
		Util.centreChild(this, dialog);
		dialog.show();

	}

	public void addTreePath(String s) {
		ParsedEntity p;
		try {
			p =
				new com.proofsecure.paros.scan.ParsedEntity(
					"",
					new URI(s),
					false);
			treePanel.addPath(p);
		} catch (HttpMalformedHeaderException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (URISyntaxException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/** Exit the Application */
	private void exitForm(java.awt.event.WindowEvent evt) {
		hide();
	}

	public void setListModel(DefaultListModel m) {
		jList1.setModel(m);
	}

	// for selection of list
	public void valueChanged(ListSelectionEvent evt) {
		// When the user release the mouse button and completes the selection,
		// getValueIsAdjusting() becomes false
		if (!evt.getValueIsAdjusting()) {
			//			JList list = (JList) evt.getSource();
			//			if (jList1 ==null) return;
			if (jList1.getSelectedValue() == null)
				return;
			String selected = (String) jList1.getSelectedValue();
			//selected = selected.substring(0, selected.indexOf("---"))+ "." + da.getDump().getCurDate();
			selected = selected.substring(0, selected.indexOf("---"));
			//			System.out.println(selected);

			//			else if (rightTabPane.getSelectedIndex() == rightTabPane.indexOfTab(ParosFrame.RESPONSE_LOG)){
			
			Vector result = null;
			if (jTabbedPane1.getSelectedIndex()
				== jTabbedPane1.indexOfTab("Request")) {
				result = da.searchRequest(selected);
				if (result != null) {
					setRequest(result);
				}

			} else if (
				jTabbedPane1.getSelectedIndex()
					== jTabbedPane1.indexOfTab("Response")) {

				result = da.searchResponse(selected);
				if (result != null) {
					setResponse(result);
					//				browser.show("text/html",(String)result.get(1));
				} else {
					result = new Vector(2);
					result.add(
						"Data with id "
							+ selected
							+ " not found.  Maybe due to response timeout or conection closed.");
					result.add(
						"Data with id "
							+ selected
							+ " not found.  Maybe due to response timeout or conection closed.");
					setResponse(result);
					// clean up the response header/body
				}
			} else if (
				jTabbedPane1.getSelectedIndex()
					== jTabbedPane1.indexOfTab("Comment") ||
				jTabbedPane1.getSelectedIndex()
					== jTabbedPane1.indexOfTab("Script")) {

				result = da.searchResponse(selected);
				if (result != null) {
					setComment(result.get(1).toString());
				} else
					setComment(null);
			}

			result = null;
			//			System.out.println(req);			
			//			String res = da.searchResponse(selected);			

		}
	}

	/**
	 * @param args the command line arguments
	 */
	public static void main(String[] args) {

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}

		boolean packFrame = false;

		DumpAnalyzerGUI da = new DumpAnalyzerGUI(new Dump());
		DumpFrame frame = new DumpFrame(da, new DefaultListModel());
		//Validate frames that have preset sizes
		//Pack frames that have useful preferred size info, e.g. from their layout
		if (packFrame) {
			frame.pack();
		} else {
			frame.validate();
		}
		//Center the window
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension frameSize = frame.getSize();
		if (frameSize.height > screenSize.height) {
			frameSize.height = screenSize.height;
		}
		if (frameSize.width > screenSize.width) {
			frameSize.width = screenSize.width;
		}
		frame.setLocation(
			(screenSize.width - frameSize.width) / 2,
			(screenSize.height - frameSize.height) / 2);
		frame.setVisible(true);

		// test data
		//		frame.addTreePath("http://www.test.com/abc/e1.asp");
		//		frame.addTreePath("http://www.test2.com/abc/e1.asp");

	}

	class ScanThread extends Thread {
		public void run() {
			btnScan.setEnabled(false);
			jList1.setEnabled(false);
			BufferedReader feed;
			//			if ((feed=da.openResponseFeed())!=null){
			try {
				ScannerOffline scanner = new ScannerOffline();
				scanner.test(da);
			} catch (Exception e) {
				System.out.println(e.getMessage());
			}
			//			}
			btnScan.setEnabled(true);
			jList1.setEnabled(true);
		}
	}

	private void initMenu() {
		// menu creation

		jMenuFile.setText("File");
		jMenuFile.setMnemonic(KeyEvent.VK_F);
		jMenuFileExit.setText("Close");
		jMenuFileExit.setMnemonic(KeyEvent.VK_E);
		jMenuFileExit.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuFileExit_actionPerformed(e);
			}
		});

		jMenuEdit.setText("Edit");
		jMenuEdit.setMnemonic(KeyEvent.VK_E);
		jMenuEditFind.setText("Find...");
		jMenuEditFind.setMnemonic(KeyEvent.VK_F);
		jMenuEditFind.setAccelerator(
			KeyStroke.getKeyStroke(KeyEvent.VK_F, KeyEvent.CTRL_MASK));
		jMenuEditFind.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuEditFind_actionPerformed(e);
			}
		});

		jMenuFile.add(jMenuFileExit);
		jMenuEdit.add(jMenuEditFind);
		jMenuBar.add(jMenuFile);
		jMenuBar.add(jMenuEdit);

		this.setJMenuBar(jMenuBar);
	}
	//File | Open action performed
	public void jMenuFileOpen_actionPerformed(ActionEvent e) {
		OpenFileDialog d = new OpenFileDialog();
		//		Util.centreChild(this, d);	
		//		d.setLocationRelativeTo(this.getContentPane());
		d.show();

	}
	//File | Exit action performed
	public void jMenuFileExit_actionPerformed(ActionEvent e) {
		hide();
	}

	//Edit | Find action performed
	public void jMenuEditFind_actionPerformed(ActionEvent e) {

		/*
		
		// does not work as always txtBody got focus.  Used pop-up window instead.
			JTextComponent txtComp = null;
		try {
			Component c = this.getMostRecentFocusOwner();
			if (c instanceof JTextComponent) {
				txtComp = (JTextComponent) c;
				txtComp.requestFocus();
			} else {
				if (jTabbedPane1.getSelectedIndex() == 0) {
					dumpRequestPanel.txtBody.requestFocus();
				} else {
					dumpResponsePanel.txtBody.requestFocus();
				}
			}
		} catch (Exception ex) {
		}
		*/

		Global.findDialog = new FindDialog(this, false);
		JDialog dialog = Global.findDialog;
		Util.centreChild(this, dialog);
		dialog.show();

	}
	/**
	 * @param string
	 * @param string2
	 */
	public void refresh(String pattern, String searchPlace) {
		// TODO Auto-generated method stub
		Pattern p = Pattern.compile(pattern);
		da.refresh(p, searchPlace);
	}
}
