/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.log;

import java.awt.BorderLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import com.proofsecure.paros.ui.ParosSplitPane;
import com.proofsecure.paros.ui.PopupPanel;

/**
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class DumpResponsePanel extends JPanel{

//  private static final String TRAPVIEW_TABULAR = "Tabular View";
//  private static final String TRAPVIEW_ORIGINAL = "Original View";

  private Pattern pSeparator	= Pattern.compile("([^=&]+)[=]([^=&]*)"); 
   private Matcher matcher2;
   
  private boolean isContinue = false;

   private JSplitPane jSplitPane5 = new JSplitPane();   
  private ParosSplitPane jSplitPane4 = new ParosSplitPane();
  private JScrollPane jScrollPane4 = new JScrollPane();
  private JScrollPane jScrollPane5 = new JScrollPane();
  private JPanel jPanel4 = new JPanel();
  private JTextArea txtHeader = new JTextArea();
  // package accessible
  JTextArea txtBody = new JTextArea();
  private JTable jTable2 = new JTable();
  private JScrollPane jScrollPane8 = new JScrollPane();    
  private JScrollPane jScrollPane9 = new JScrollPane();      
  private Box box1;
  private JButton jButton4 = new JButton();


  /**
   * 
   */
  public DumpResponsePanel() {
	  super();
		init();
  }
    

  private void init(){
	try {
	  UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	}
	catch(Exception e) {
	  e.printStackTrace();
	}
	box1 = Box.createHorizontalBox();
//	  box1.setBackground(SystemColor.activeCaptionBorder);
//	  box1.setForeground(SystemColor.activeCaptionBorder);
    
	this.setLayout(new BorderLayout());
	this.setBackground(SystemColor.activeCaptionBorder);  
    
	 jPanel4.setLayout(new BorderLayout());
	jSplitPane4.setOrientation(JSplitPane.VERTICAL_SPLIT);
	jSplitPane4.setDividerSize(3);
     
	   jScrollPane8.getViewport().add(jTable2, null);
	jSplitPane5.add(jPanel4, JSplitPane.LEFT);          
	jSplitPane5.add(jScrollPane8, JSplitPane.RIGHT);
	jSplitPane5.setDividerSize(0);
    
	this.add(jSplitPane5, BorderLayout.CENTER);
	this.add(jScrollPane9, BorderLayout.SOUTH);    


	jScrollPane9.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
	jScrollPane9.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
//	jScrollPane9.setMinimumSize(new Dimension(100,200));
//	jScrollPane9.getViewport().add(box1, null);
//	  box1.setBackground(SystemColor.activeCaptionBorder);
//	  box1.setForeground(SystemColor.activeCaptionBorder);
	jButton4.setText("Continue");
	jButton4.addActionListener(new java.awt.event.ActionListener() {
	  public void actionPerformed(ActionEvent e) {
		jButton4_actionPerformed(e);
	  }
	});
//	box1.add(jButton4, null);
        
	jPanel4.add(jSplitPane4.getJSplitPaneHeader(), BorderLayout.WEST);
	jPanel4.add(jSplitPane4, BorderLayout.CENTER);
	jSplitPane4.add(jScrollPane4, JSplitPane.TOP);
	jSplitPane4.add(jScrollPane5, JSplitPane.BOTTOM);    

	txtHeader.setLineWrap(true);
	txtBody.setLineWrap(true);
	txtHeader.setEditable(false);
	txtBody.setEditable(false);
	txtHeader.setFocusable(true);
	txtBody.setFocusable(true);
	txtHeader.setBackground(SystemColor.activeCaptionBorder);
	txtBody.setBackground(SystemColor.activeCaptionBorder);
	jScrollPane5.getViewport().add(txtBody, null);
	jScrollPane4.getViewport().add(txtHeader, null);

	jScrollPane8.setVisible(false);    
    
	
    txtHeader.addMouseListener (new MouseAdapter() {
      public void mousePressed (MouseEvent e) {
        if ((e.getModifiers() & InputEvent.BUTTON3_MASK) != 0) {  // right mouse button
          PopupPanel pp = new PopupPanel(txtHeader);   // should pass component to popup
          pp.getPopupMenu().show (e.getComponent(),
            e.getX(), e.getY());
        }
        else{
          super.mousePressed(e);
        }
      }
    });

    txtBody.addMouseListener (new MouseAdapter() {
      public void mousePressed (MouseEvent e) {
        if ((e.getModifiers() & InputEvent.BUTTON3_MASK) != 0) {  // right mouse button
          PopupPanel pp = new PopupPanel(txtBody);   // should pass component to popup
          pp.getPopupMenu().show (e.getComponent(),
            e.getX(), e.getY());
        }
        else{
          super.mousePressed(e);
        }
      }
    });

/*
	txtBody.addMouseListener (new MouseAdapter() {
	  public void mousePressed (MouseEvent e) {
		  super.mousePressed(e);
	  }
	});
*/
    
  }

  public boolean isContinue(){
	return isContinue;
  }

  public void setContinue(boolean s){
	isContinue = s;
  }


  public String getHeader(){
	 String result = txtHeader.getText().replaceAll("\\n","\r\n");
	 result = result.replaceAll("(\\r\\n)*\\z","") + "\r\n\r\n";
	 return result;              
  }

  public String getBody(){
	 return txtBody.getText();
  }

  public void setMessage(final String header, final String body){
         
			SwingUtilities.invokeLater(new Runnable() {
//			  try {
//				EventQueue.invokeAndWait(new Runnable() {

			  public void run() {
				  txtHeader.setText(header.replaceAll("\\r\\n","\n"));
				  txtHeader.setCaretPosition(0);
				  if (body == null) {
					txtBody.setEnabled(false);
				  } else {
					txtBody.setEnabled(true);
					txtBody.setText(body);
					txtBody.setCaretPosition(0);
				  }              
//					if (header!=null && header.equals("") && body!=null && body.equals("")){
//						  txtBody.setEnabled(true);
//					}
			  }
			 });
//			  }catch(Exception ie){
//				System.out.println(ie.getMessage());
//			  }             
  }

  void jButton4_actionPerformed(ActionEvent e) {
	isContinue = true;
  }
  
 
}

