/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.log;

import java.util.Vector;
import java.util.regex.Pattern;

import javax.swing.JOptionPane;
import javax.swing.UIManager;

/**
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */

public class GrepDialog extends javax.swing.JDialog  {
    private DumpAnalyzer analyzer=null;
    
	/** Creates new form GrepDialog */
	public GrepDialog(java.awt.Frame parent, boolean modal, DumpAnalyzer da) {
		super(parent, modal);
		analyzer = da;
		initComponents();
	}
    
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	private void initComponents() {
		buttonGroup1 = new javax.swing.ButtonGroup();
		jPanel1 = new javax.swing.JPanel();
		jRadioButton1 = new javax.swing.JRadioButton();
		jRadioButton2 = new javax.swing.JRadioButton();
		jPanel2 = new javax.swing.JPanel();
		jPanel3 = new javax.swing.JPanel();
		jLabel1 = new javax.swing.JLabel();
		jTextField1 = new javax.swing.JTextField();
		jButton1 = new javax.swing.JButton();
		jScrollPane1 = new javax.swing.JScrollPane();
		jTextArea1 = new javax.swing.JTextArea();

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}
//		setIconImage(Toolkit.getDefaultToolkit().createImage("paros_logo.gif"));
		setTitle("Extract pattern in the log using Java regular expression");
		setModal(false);
		setResizable(false);
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent evt) {
				closeDialog(evt);
			}
		});

		jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.X_AXIS));

		jPanel1.setMaximumSize(new java.awt.Dimension(400, 24));
		jPanel1.setMinimumSize(new java.awt.Dimension(400, 24));
		jPanel1.setPreferredSize(new java.awt.Dimension(400, 24));
		jRadioButton1.setText("Request");
		jRadioButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				if (jRadioButton2.isSelected())
					jRadioButton2.setSelected(false);				
				jRadioButton1.setSelected(true);
				
			}
		});

		jPanel1.add(jRadioButton1);
		jRadioButton1.setSelected(true);
		jRadioButton2.setText("Response");

		jRadioButton2.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				if (jRadioButton1.isSelected())
					jRadioButton1.setSelected(false);
				jRadioButton2.setSelected(true);
			}
		});

		jPanel1.add(jRadioButton2);
		
		getContentPane().add(jPanel1, java.awt.BorderLayout.NORTH);
		
		jPanel2.setLayout(new java.awt.BorderLayout());

		jPanel2.setMaximumSize(new java.awt.Dimension(450, 450));
		jPanel2.setMinimumSize(new java.awt.Dimension(450, 450));
		jPanel2.setPreferredSize(new java.awt.Dimension(450, 450));
		jPanel3.setLayout(new javax.swing.BoxLayout(jPanel3, javax.swing.BoxLayout.X_AXIS));

		jLabel1.setText("Pattern ");
		jPanel3.add(jLabel1);

		jPanel3.add(jTextField1);

		jButton1.setText("Extract");
		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton1ActionPerformed(evt);
			}
		});

		jPanel3.add(jButton1);

		jPanel2.add(jPanel3, java.awt.BorderLayout.NORTH);

		jScrollPane1.setViewportView(jTextArea1);

		jPanel2.add(jScrollPane1, java.awt.BorderLayout.CENTER);

		getContentPane().add(jPanel2, java.awt.BorderLayout.CENTER);

		pack();
	}
	

	private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {
		if (jTextField1.getText()==null || jTextField1.getText().equals("")){
			return;
		}
		
		Pattern p = null;
		jTextArea1.setText(null);
		try{
			p = Pattern.compile(jTextField1.getText(),Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
		}
		catch(Exception e){
			JOptionPane.showMessageDialog(this, "Error: " + e.getMessage());
			return;
		}
		
		String searchWhere = "request";
		if (jRadioButton2.isSelected())
			searchWhere = "response";

		/*
		isStop = false;
		WaitingDialog w = new WaitingDialog((TaskThread)this, null , false); 
		w.show();
		while (!w.isVisible()){}
		*/
		//System.out.println("test");
		Vector result = analyzer.listPattern(p , searchWhere);
//		w.closeDialog();
		if (result==null) return;
		String s ="";
		for (int i=0;i<result.size();i++){
			String one = (String)result.get(i);
			if (one.endsWith("\r\n"))
				s += one;
			else
				s += one + "\r\n";
		}
		
		jTextArea1.setText(s);
		
	}
    
	/** Closes the dialog */
	private void closeDialog(java.awt.event.WindowEvent evt) {
		setVisible(false);
		dispose();
	}
    
	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
//		new GrepDialog(new javax.swing.JFrame(), true, da).show();
	}
    
    
	// Variables declaration - do not modify
	private javax.swing.ButtonGroup buttonGroup1;
	private javax.swing.JButton jButton1;
	private javax.swing.JLabel jLabel1;
	private javax.swing.JPanel jPanel1;
	private javax.swing.JPanel jPanel2;
	private javax.swing.JPanel jPanel3;
	private javax.swing.JRadioButton jRadioButton1;
	private javax.swing.JRadioButton jRadioButton2;
	private javax.swing.JScrollPane jScrollPane1;
	private javax.swing.JTextArea jTextArea1;
	private javax.swing.JTextField jTextField1;
	/* (non-Javadoc)
	 * @see com.proofsecure.paros.ui.TaskThread#setStop()
	 */
	// End of variables declaration
    
}
