/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.network;

import java.net.Socket;
import java.net.URISyntaxException;

class HttpUtil {
	
	static void close(Socket socket) {
		try {
			if (socket != null) {
				socket.close();
			}
		} catch (Exception e) {
		}
	}
	
	public static String encodeURI(String uri) throws URISyntaxException {
		
		StringBuffer sb = new StringBuffer();
		String tmp = null;
		
		//try {
		//	tmp = URLEncoder.encode(uri, "8859_1");
		//} catch (UnsupportedEncodingException e) {
		//}
		
		tmp = uri.replaceAll(" ", "%20");
		tmp = tmp.replaceAll("<", "%3C");
		tmp = tmp.replaceAll(">", "%3E");
		tmp = tmp.replaceAll("'", "%27");
		tmp = tmp.replaceAll("\\x28", "%28");	// left bracket
		tmp = tmp.replaceAll("\\x29", "%29");		// right bracket
		tmp = tmp.replaceAll("\\x22", "%22");	// double quote
		
		return tmp;
	}
}