/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import java.net.URI;
import java.net.URISyntaxException;

import com.proofsecure.paros.network.HttpHeader;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpRequestHeader;

public class ParsedFolder extends ParsedEntity {
	public ParsedFolder(String caption, URI uri, ParsedEntity inheritedEntity) throws HttpMalformedHeaderException, URISyntaxException {

		super(caption, uri, inheritedEntity.getSecure());
		setHostName(inheritedEntity.getHostName());
		setHostPort(inheritedEntity.getHostPort());

		getRequestHeader().setMessage(inheritedEntity.getRequestHeader().toStringAbsoluteUri());
		getRequestHeader().setURI(uri.toString());
		getRequestHeader().setMethod(HttpRequestHeader.GET);
		getRequestHeader().setContentLength(0);
		getRequestHeader().setHostName(getHostName());
		getRequestHeader().setHostPort(getHostPort());
		
		// clean up headers
		getRequestHeader().setHeader(HttpHeader.IF_MODIFIED_SINCE, null);
		getRequestHeader().setHeader(HttpHeader.IF_NONE_MATCH, null);
		getRequestBody().setBody("");

	}
}
