/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.scan;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Report {

    private static Pattern patternWindows = Pattern.compile("window", Pattern.CASE_INSENSITIVE);
	private static Pattern patternLinux = Pattern.compile("linux", Pattern.CASE_INSENSITIVE);

	private static final SimpleDateFormat staticDateFormat = new SimpleDateFormat();
	
	public static File stringToHtml (String inxml, String infilexsl, String outfilename) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    	Document doc = null;

        //factory.setNamespaceAware(true);
        //factory.setValidating(true);
 		File stylesheet 		= null;
 		File outfile			= null;
 		StringReader inReader	= new StringReader(inxml);
 		
        try {
            stylesheet = new File(infilexsl);
            outfile	= new File(outfilename);
 
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new InputSource(inReader));
            
            // Use a Transformer for output
            TransformerFactory tFactory =
                TransformerFactory.newInstance();
            StreamSource stylesource = new StreamSource(stylesheet);
            Transformer transformer = tFactory.newTransformer(stylesource);
 
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(outfile);
            transformer.transform(source, result);

        } catch (TransformerConfigurationException tce) {
           // Error generated by the parser
           System.out.println ("\n** Transformer Factory error");
           System.out.println("   " + tce.getMessage() );

           // Use the contained exception, if any
           Throwable x = tce;
           if (tce.getException() != null)
               x = tce.getException();
           x.printStackTrace();
      
        } catch (TransformerException te) {
           // Error generated by the parser
           System.out.println ("\n** Transformation error");
           System.out.println("   " + te.getMessage() );

           // Use the contained exception, if any
           Throwable x = te;
           if (te.getException() != null)
               x = te.getException();
           x.printStackTrace();
           
         } catch (SAXException sxe) {
           // Error generated by this application
           // (or a parser-initialization error)
           Exception  x = sxe;
           if (sxe.getException() != null)
               x = sxe.getException();
           x.printStackTrace();

        } catch (ParserConfigurationException pce) {
            // Parser with specified options can't be built
            pce.printStackTrace();

        } catch (IOException ioe) {
           // I/O error
           ioe.printStackTrace();
        } finally {

        }
                
		return outfile;

    }

    
    public static File fileToHtml (String infilexml, String infilexsl, String outfilename) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    	Document doc = null;

        //factory.setNamespaceAware(true);
        //factory.setValidating(true);
 		File stylesheet 	= null;
 		File datafile		= null;
 		File outfile		= null;
 		
        try {
            stylesheet = new File(infilexsl);
            datafile   = new File(infilexml);
            outfile	= new File(outfilename);
 
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(datafile);
 
            // Use a Transformer for output
            TransformerFactory tFactory =
                TransformerFactory.newInstance();
            StreamSource stylesource = new StreamSource(stylesheet);
            Transformer transformer = tFactory.newTransformer(stylesource);
 
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(outfile);
            transformer.transform(source, result);

        } catch (TransformerConfigurationException tce) {
           // Error generated by the parser
           System.out.println ("\n** Transformer Factory error");
           System.out.println("   " + tce.getMessage() );

           // Use the contained exception, if any
           Throwable x = tce;
           if (tce.getException() != null)
               x = tce.getException();
           x.printStackTrace();
      
        } catch (TransformerException te) {
           // Error generated by the parser
           System.out.println ("\n** Transformation error");
           System.out.println("   " + te.getMessage() );

           // Use the contained exception, if any
           Throwable x = te;
           if (te.getException() != null)
               x = te.getException();
           x.printStackTrace();
           
         } catch (SAXException sxe) {
           // Error generated by this application
           // (or a parser-initialization error)
           Exception  x = sxe;
           if (sxe.getException() != null)
               x = sxe.getException();
           x.printStackTrace();

        } catch (ParserConfigurationException pce) {
            // Parser with specified options can't be built
            pce.printStackTrace();

        } catch (IOException ioe) {
           // I/O error
           ioe.printStackTrace();
        } finally {

        }
                
		return outfile;

    }
    
    public static void openBrowser(String uri) {
		Matcher matcher = null;
		
		try {
			String os_name = System.getProperty("os.name");
		
			matcher = patternWindows.matcher(os_name);
			if (matcher.find()) {
				// is windows
				int pos = uri.lastIndexOf("\\");
				String path = uri.substring(0, pos);
				String file = uri.substring(pos+1);
				Runtime.getRuntime().exec("cmd /c start /D\"" + path + "\" " + file);
				return;
			}
			
			matcher = patternLinux.matcher(os_name);
			if (matcher.find()) {
				// is Linux
				Runtime.getRuntime().exec("mozilla " + uri);
				return;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	Encode entity for HTML or XML output.
	*/
	public static String entityEncode(String text) {
		String result = text;
		
		if (result == null) {
			return result;
		}

		// & must be the first one to replace because all other entity depends on &.
		result = result.replaceAll("&", "&amp;");
		
		result = result.replaceAll("<", "&lt;");
		result = result.replaceAll(">", "&gt;");
		result = result.replaceAll("\"", "&quot;");
		result = result.replaceAll("'", "&apos;");

		
		return result;
	}
	
	/**
	Get today's date string.
	*/
	public static String getCurrentDateTimeString() {
		Date dateTime = new Date(System.currentTimeMillis());
		return staticDateFormat.format(dateTime);
	}

}
