/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.scan;

import java.util.Enumeration;
import java.util.Vector;

import com.proofsecure.paros.FunctionManager;
import com.proofsecure.paros.Global;

public class ScanManager extends FunctionManager{ //extends Thread implements HeaderFilter{
 protected final String path = ".//paros//scan//"; 
 protected final String cpath = "paros.scan."; 
 protected final String classtype = ".class"; 

 private static final String[] superClassList = {"TestServerDefault", "AbstractAppTest", "TestAbstractParam", "AbstractServerTest"};

 public void createList(){
      Enumeration v = this.getNames();

      while (v.hasMoreElements()) {
        String name = (String)v.nextElement();
        Vector row = new Vector();
        row.add(new Boolean(true));  //set to false for first time
        row.add(((AbstractTest)items.get(name)).toString());
        row.add(((AbstractTest)items.get(name)).getTestName());
//        row.add(((Filter)items.get(name)).getDialog());  //set to false for first time
        enablelist.add(row);
           
       }

 }
 
  /**
      init the ScanManager, which is called once (static) in ProxyHandler
      @param  
      @return
  */
  protected void init(){     
  	if (Global.isST)
  		Global.isDumpScan = true;
  
    items.put("TestXSS", new TestXSS());  
    items.put("TestSQLInjection", new TestSQLInjection());  
    items.put("TestDirBrowse", new TestDirBrowse());  
    items.put("TestHttpMethod", new TestHttpMethod());  
    items.put("TestObsoleteFile", new TestObsoleteFile());
    items.put("TestCacheAndMisc", new TestCacheAndMisc());
    items.put("TestParamTamper", new TestParamTamper());
	items.put("TestCRLFInjection", new TestCRLFInjection());
	items.put("TestCipherSuite", new TestCipherSuite());
    items.put("TestServerIIS", new TestServerIIS());  
    items.put("TestServerJRun", new TestServerJRun());  
    items.put("TestServerTomcat", new TestServerTomcat());  
    items.put("TestServerWebSphere", new TestServerWebSphere());  
    items.put("TestServerColdFusion", new TestServerColdFusion());
    items.put("TestServerWebLogic", new TestServerWebLogic());
	items.put("TestBufferOverflow", new TestBufferOverflow());
	if (Global.isST) {
		items.put("TestPERLInjection", new TestPerlInjection());
		items.put("TestServerSideInclude", new TestServerSideInclude());
		
	}
	
//    items.put("TestTomcatViewSource", new TestTomcatViewSource());  

    
  }


  /**
      init the ScanManager, which is called once (static) in ProxyHandler
      @param  
      @return
  */

  /**
      Called by proxyHandler to filter each HTTP request/response headers
      @param  header  header to be filtered
      @param  body		body to be filtered
      @param  
  
    public void process(){
    }
  */


  /**
      check if the filter has interface HeaderFilter
      @param  cls   class of the filter
      @return yes or no
   */
  protected  boolean isFilter(Class cls){
	Class intfs1 = cls.getSuperclass();  
	for (int i=0; i<superClassList.length; i++) {
		if (intfs1 != null && intfs1.getName().equals(cpath + superClassList[i])) {
			return true;
		}
	}
	/*
	if (intfs1!=null && intfs1.getName().equals(cpath + className1)){
    	return true;
	}
	if (intfs1!=null && intfs1.getName().equals(cpath + className2)){
    	return true;
	}
	*/

    return false;
  }

      
  //Main method
  public static void main(String[] args) {
      ScanManager fm = new ScanManager();
  }
  
}



 
