/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.log.Dump;
import com.proofsecure.paros.log.DumpAnalyzerGUI;
import com.proofsecure.paros.network.HttpMalformedHeaderException;

//import java.util.Enumeration;
//import java.util.Hashtable;
//import java.util.Vector;
//
//import com.proofsecure.paros.Global;

/**
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ScannerOffline extends AbstractScanner{
	/**
	 * 
	 */
//	 	protected AlertDB		mAlertDB = new AlertDB();
//	private TreeSet			mAlertList = new TreeSet();
	protected static final String CRLF = "\r\n";
	protected static java.text.DecimalFormat decFormat = new java.text.DecimalFormat("##0.###");

	protected void process(){
	}
	
	protected void endOfProcess() {
		Global.currentScanner = null;

		Global.scanner.generateAlertReport();
	}
		
	public ScannerOffline() throws Exception{
		super();
		// TODO Auto-generated constructor stub
		Global.currentScanner = this;
		removeAllAlert();
	}

	public synchronized void test(DumpAnalyzerGUI da) {
//	public synchronized void test(BufferedReader responseFeed) {
		long startTime = 0, diffTime = 0;

		String curDateTime = Long.toString(da.getDump().getCurDate());

		// currently need to clean up here because all AbstractTest will write to the Global.scanner
		
		Global.scanner.removeAllAlert();

		startTime = System.currentTimeMillis();

		com.proofsecure.paros.util.Util.writeOutput("Offline scanning ...");

		Pattern patHeader = null;
			
		if (da.isCurSession()){
			patHeader =	Pattern.compile(
					Dump.SEPARATOR_LEFT
						+ "\\d+[-]((\\d+)[.](" + curDateTime + "))"
						+ Dump.SEPARATOR_RIGHT);			
		}
		else
		patHeader =	Pattern.compile(
				Dump.SEPARATOR_LEFT
					+ "\\d+[-]((\\d+)[.](\\d+))"
					+ Dump.SEPARATOR_RIGHT);			
		

		String line = "";
		String curID, nextID ="";


		Matcher matcher = null;
		CharSequence cs = null;
		TestCacheAndMisc testModel = null;
		
		try {
			cs = fromFile(da.getDump().getFilePath(Dump.REQUEST_FILE));
			matcher = patHeader.matcher(cs);
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} 
		int startRes =0;
		int endRes ;

		while (matcher.find(startRes)){
			String thisID = matcher.group(1);
			// located the right response
			startRes = matcher.end();
			
			if (matcher.find(startRes)){
				endRes = matcher.start();
			}
			else{
				endRes = cs.length();
			}

			// get request and response from log
			String request = cs.subSequence(startRes+2, endRes).toString(); // the '2' here is to skip "\r\n"

			int split;
			Vector result = new Vector(2);
			if ((split=request.indexOf("\r\n\r\n"))==-1){				 
				result.add(request + "\r\n");
				result.add("");
			}
			else{
				result.add(request.substring(0,split) + "\r\n");
				result.add(request.substring(split+4));
			}
			Vector v = (Vector)da.searchResponse(thisID);

			// set the request and response 
			try {
				testModel = new TestCacheAndMisc();
				testModel.getRequestHeader().setMessage(result.get(0).toString());
				testModel.getRequestBody().setBody(result.get(1).toString());
				if (v!=null){
					testModel.getResponseHeader().setMessage(v.get(0).toString());
					testModel.getResponseBody().setBody(v.get(1).toString());
				}
				else{
					testModel.getResponseHeader().setMessage(null);
					testModel.getResponseBody().setBody(null);					
				}

			} catch (HttpMalformedHeaderException e) {
				System.out.println("HttpMalformedHeader: " + e.getMessage());
				continue;
			}

			try {
			testModel.scanOffline();
			} catch (Exception e2) {
				// TODO Auto-generated catch block
				e2.printStackTrace();
			}

		}			


		java.text.DecimalFormat decFormat =
			new java.text.DecimalFormat("##0.###");

		diffTime = System.currentTimeMillis() - startTime;
		String diffTimeString =
			decFormat.format((double) (diffTime / 1000.0)) + "s";

		com.proofsecure.paros.util.Util.writeOutput(
			"Offline scanning completed in " + diffTimeString);
		com.proofsecure.paros.util.Util.writeStatus("Done.");

			endOfProcess();
	}
/*	
	public static void writeOutput(String s){
		System.out.println(s);
	}
	public static void writeStatus(String s){
		System.out.println(s);
	}
*/	
	private CharSequence fromFile(String filename) throws IOException {
		FileInputStream fis = new FileInputStream(filename);
		FileChannel fc = fis.getChannel();
	
		// Create a read-only CharBuffer on the file
		MappedByteBuffer bbuf =
			fc.map(FileChannel.MapMode.READ_ONLY, 0, (int) fc.size());
		CharBuffer cbuf = Charset.forName("8859_1").newDecoder().decode(bbuf);
		return cbuf;
	}

	
	public static void main(String[] args) {
		try{
		ScannerOffline s = new ScannerOffline();
		}
		catch(Exception e){}

	}
}
