/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import java.io.IOException;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.Matcher;

import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpStatusCode;

abstract class TestAbstractParam extends AbstractAppTest {


	TestAbstractParam() {
	}

	HttpRequestHeader	myReqHeader	= new HttpRequestHeader();
	HttpBody			myReqBody	= new HttpBody();
	String				myHostPath	= null;
	String				myQuery		= null;

    public String toString() {
        return "TestAbstractParam";
    }

    
	
	/*	This is to be defined by subclass
	public String getTestName() {
		return "Abstract test parameters.";
	}
	*/

	/**
	Build header using the given hostPath and query as start-line.
	The other headers will use stored header template.
	*/	
	protected void buildHeader(String hostPath, String query) throws HttpMalformedHeaderException {
		String sUri = hostPath;
		if (query != null && query.length() > 0) {
			sUri = sUri + "?" + query;
		}
		getRequestHeader().setMessage(myReqHeader.toStringAbsoluteUri());
		getRequestHeader().setURI(sUri);
	
	}


	private static Pattern staticPatternParam = Pattern.compile("&", Pattern.CASE_INSENSITIVE);	
	private Vector getParsedParam(String params) {
		Vector paramList = new Vector();
		String[] keyValue = staticPatternParam.split(params);
		String key = null;
		String value = null;
		int pos = 0;
		for (int i=0; i<keyValue.length; i++) {
			key = null;
			value = null;
			pos = keyValue[i].indexOf('=');
			try {
				if (pos > 0) {
					key = keyValue[i].substring(0,pos);
					value = keyValue[i].substring(pos+1);
					
					paramList.add(new UrlParam(key, value));

				}
			} catch (Exception e) {
			}
		}
		
		return paramList;
	}
	
	protected void checkUrlOrBody(boolean isBody, String params) throws Exception {
		Vector paramList = getParsedParam(params);
		StringBuffer sb = new StringBuffer();
		UrlParam	keyValue = null;
		String		paramKey = null;
		String		paramValue = null;
		int			pos = 0;
		
		restore();
		// stop gracefully if stop scan
		for (int i=0; i<paramList.size() && !isSignalStop(); i++) {
			sb.setLength(0);
			paramKey = ((UrlParam) paramList.elementAt(i)).key;
			paramValue = ((UrlParam) paramList.elementAt(i)).value;
			for (int j=0; j<paramList.size(); j++) {
				keyValue = (UrlParam) paramList.elementAt(j);
				if (i == j) {
					pos = sb.length();
				} else {
					sb.append(keyValue.key + "=");
					if (keyValue.value != null && keyValue.value.length() > 0) {
						sb.append(keyValue.value);
					}
					if (j+1 != i && j < paramList.size() -1) {
						sb.append("&");
					}
				}

				
			}

			String query = sb.toString();
			check(isBody, paramKey, paramValue, query, pos);
		}
	}

	abstract protected void check(boolean isBody, String paramKey, String paramValue, String newQuery, int pos) throws IOException;
	
	protected void createMessage(boolean isBody, String newQuery) throws HttpMalformedHeaderException {
		if (isBody) {
			// mutate parameter in body	
			getRequestHeader().setContentLength(newQuery.length());
			getRequestBody().setBody(newQuery);
		} else {
			// mutate paramter in URL parameter
			buildHeader(myHostPath, newQuery.toString());
			getRequestBody().setBody(myReqBody.toString());
		}
	}

	
	/**
	Insert the newParam into the position of oldQuery.  Automatically add '&' if needed.

	if newParam == null then exit	
	*/
	protected String insertQuery(String oldQuery, int pos, String newParam) {
		String insertParam = "";

		if (newParam == null || newParam.length() == 0) {
			return oldQuery;
		}

		if (pos > 0) {
			insertParam = "&" + insertParam;
		}
		insertParam = insertParam + newParam;
		if (pos < oldQuery.length()) {
			insertParam = insertParam + "&";
		}

		StringBuffer sb = new StringBuffer(oldQuery);
		String result = sb.insert(pos, insertParam).toString();

		return result;
	}

	/**
	Initialize header and query parameters.
	*/
	protected void init() throws HttpMalformedHeaderException {
		myHostPath	= new String(getRequestHeader().getURIHostPath());
		myQuery		= new String(getRequestHeader().getURIQuery());

		myReqHeader.setMessage(getRequestHeader().toStringAbsoluteUri());
		myReqHeader.setSecure(getRequestHeader().getSecure());
		myReqBody.setBody(getRequestBody().toString());
		
	}

	/**
	Restore request header to original value.
	*/	
	protected void restore() throws HttpMalformedHeaderException {
		getRequestHeader().setMessage(myReqHeader.toStringAbsoluteUri());
		getRequestHeader().setSecure(myReqHeader.getSecure());
		getRequestBody().setBody(myReqBody.toString());
	}
	

	/**
	 Simple check for each pattern (without other requirement use this.  Reference TestServerSideInclude.
	 */	
	protected boolean checkEachPattern(boolean isBody, String paramKey, String paramValue,
			String query, int insertPos, String tamper, Pattern checkPattern) throws IOException {

		String bingoQuery = null;
		String newQuery = null;		
		String resBody;
		Matcher matcher = null;
		boolean result = false;
		
		bingoQuery = insertQuery(query, insertPos, paramKey + "=" + paramValue + tamper);
		createMessage(isBody, bingoQuery);
		sendAndReceive();

		if (getResponseHeader().getStatusCode() == HttpStatusCode.OK) {
			resBody = getResponseBody().toString();
			matcher = checkPattern.matcher(resBody);
			if (matcher.find()) {
				return true;
			}
		}
		
		return false;
		
	}

}