/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import java.io.IOException;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.regex.Matcher;

import com.proofsecure.paros.network.HttpStatusCode;

class TestCRLFInjection extends TestAbstractParam {

	private static Random	staticRandomGenerator = 	new Random();
	private String randomString = "Tamper=" + Long.toString(Math.abs(staticRandomGenerator.nextLong()));
	private String cookieTamper1 = "%0D%0ASet-cookie:%20" + randomString + "%0D%0A";
	private String cookieTamper2 = "%0ASet-cookie:%20" + randomString + "%0A";

	// should not be changed to static as Global may not be ready
	private String[] PARAM_LIST = {cookieTamper1, cookieTamper2};
	
	private Pattern patternCookieTamper = Pattern.compile("Set-cookie: " + randomString, PATTERN_PARAM);
	
	TestCRLFInjection() {
	}

    public String toString() {
        return "TestCRLFInjection";
    }
    
	public String getTestName() {
		return "CRLF Injection";
	}	
	
	protected void check(boolean isBody, String paramKey, String paramValue, String query, int insertPos) throws IOException {

		String bingoQuery = null;
		String displayURI = null;
		String newQuery = null;
		
		String resBodyNormal = null;
		
		int pos = 0;
		long defaultTimeUsed = 0;
		long timeUsed = 0;
		long lastTime = 0;
		
		// always try normal query first
		newQuery = insertQuery(query, insertPos, paramKey + "=" + paramValue);
		createMessage(isBody, newQuery);
		lastTime = System.currentTimeMillis();
		sendAndReceive();
		defaultTimeUsed = System.currentTimeMillis() - lastTime;
		if (getResponseHeader().getStatusCode() != HttpStatusCode.OK) {
			return;
		}
		resBodyNormal = getResponseBody().toString();
		
		// loop parameters
		for (int i=0; i<PARAM_LIST.length; i++) {
			if (i == 0) {
				// try without the parameter
				bingoQuery = insertQuery(query, insertPos, "");
			} else {
				bingoQuery = insertQuery(query, insertPos, paramKey + "=" + PARAM_LIST[i]);
			}
			createMessage(isBody, bingoQuery);
			lastTime = System.currentTimeMillis();
			sendAndReceive();
			defaultTimeUsed = System.currentTimeMillis() - lastTime;
			displayURI = getRequestHeader().getURIHostPathQuery();

			if (checkResult(bingoQuery, resBodyNormal)) {
				return;
			}
		}

		
	}

	private boolean checkResult(String query, String normalHTTPResponse) {

		if (getResponseHeader().getStatusCode() != HttpStatusCode.OK
			&& !HttpStatusCode.isServerError(getResponseHeader().getStatusCode())) {
			return false;
		}
		
		// remove false positive if parameter have no effect on output
		if (getResponseBody().toString().equals(normalHTTPResponse)) {
			return false;
		}
		
		Matcher matcher = patternCookieTamper.matcher(getResponseHeader().toString());
		if (matcher.find()) {
			bingo(10007, AlertItem.RISK_MEDIUM, AlertItem.WARNING, "", query, "");
			return true;
		}
		
		return false;
		
	}

	
	private void bingo(boolean isSuspicious, String query, String uri, String other) {
		String result = (isSuspicious) ? "Suspicious" : "Warning";
		if (uri == null) {
			uri = getRequestHeader().getURIHostPathQuery();
		}
		writeOutput(result + " -\tCookie tampering or CRLF injection: " + uri);

		writeOutput("\tQuery: " + ((query == null || query.length() == 0) ? "[empty]" : query));
		if (other != null) {
			writeOutput("\tDetail: " + other);
		}
	}
	
	protected void scan() throws Exception {
		boolean skip = (getEntity().mState == ParsedEntity.DO_NOT_SCAN);
			
		writeStatus("CRLF Injection: " + (skip? "(skipped) " : "") + getRequestHeader().getURIHostPath());
		if (skip) {
			return;
		}
		init();
		checkUrlOrBody(false, myQuery);
		checkUrlOrBody(true, myReqBody.toString());
	}


}