/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

class TestObsoleteFile extends AbstractAppTest {

	private final static String[] staticSuffixList = {
			".old", ".OLD", ".Old",
			".bak", ".BAK", ".Bak",
			".java",
			".inc", ".INC", ".Inc"
//			,".class"
//			,".backup", ".BACKUP", ".Backup",
//			".pl", ".c", ".cpp"
		};

	private static String[] staticAppendixList = {
		"~"
	};

	private final static Pattern patternNotFound = Pattern.compile("(\\bNot\\sfound\\b)|(\\b404\\b)", PATTERN_PARAM);

	public TestObsoleteFile() {
	}

    public String toString() {
        return "TestObsoleteFile";
    }
    
	public String getTestName() {
		return "Obsolete Files";
	}


	protected void scan() throws Exception {
		for (int i=0; i<staticSuffixList.length; i++) {
			testSuffix(staticSuffixList[i], false);
			testSuffix(staticSuffixList[i], true);
		}

		for (int i=0; i<staticAppendixList.length; i++) {
			testSuffix(staticAppendixList[i], false);
		}

	}

	/**
	Test existence of obsolete file with the suffix.
	@param suffix suffix to run scan with.
	@param	replaceSuffix true = replace the suffix for checking.  false = append the suffix.
	*/
	private void testSuffix(String suffix, boolean replaceSuffix) throws URISyntaxException, IOException {
		URI		oldUri	= getEntity().getURIHostPath();
		String 	path 	= oldUri.getPath();
		
		if (path == null || path.equals("")) {
			return;
		}
		
		if (replaceSuffix) {
			int pos = path.lastIndexOf(".");
			if (pos > -1) {
				path = path.substring(0, pos);
			}
		}
		
		path = path + suffix;
		
		URI uri = new URI(oldUri.getScheme(), null, oldUri.getHost(), oldUri.getPort(), path, null, null);

		
		getRequestHeader().setURI(uri.toString());
		writeStatus("ObsoleteFile: " + getRequestHeader().getURIHostPath());
		sendAndReceive();

		if (!isFileExist(getEntity(), getRequestHeader(), getResponseHeader(), getResponseBody())) {
			return;
		}
		/*
		if (getResponseHeader().getStatusCode() != HttpStatusCode.OK) {
			return;
		}

		if (matchBodyPattern(patternNotFound)) {
			return;
		}
		*/

		bingo(10002, AlertItem.RISK_LOW, AlertItem.WARNING, uri.toString(), "", "");

	}


}