/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;

import java.util.regex.Pattern;


abstract class TestServerDefault extends AbstractServerTest {

	private static final Pattern patternItems = Pattern.compile(",");
	private static final String[]	SPECIAL_TAG_LIST = {
		"@cgibin"
	};
	
	private static final String[]	TAG_REPLACE_LIST = {
		"cgi-bin,cgi-local,htbin,cgi,cgis,cgi-win,bin,scripts"
	};
	
	abstract protected int getAlertID();
	
	protected void addTest(String directories, String files) {
		ParsedEntity entity	= getEntity();
		String[] 	dirList = null,
					fileList = null;
		String		dir = "",
					file = "";
		TestURL		test = null;

		directories = directories.trim();
		files = files.trim();
		for (int i=0; i<SPECIAL_TAG_LIST.length; i++) {
			directories = directories.replaceAll(SPECIAL_TAG_LIST[i], TAG_REPLACE_LIST[i]);
		}
				
		try {
			dirList = patternItems.split(directories);
			fileList = patternItems.split(files);
			for (int i=0; i<dirList.length; i++) {
				dir = dirList[i].trim();
				if (!dir.startsWith("/")) {
					dir = "/" + dir;
				}

				for (int j=0; j<fileList.length; j++) {
					file = fileList[j].trim();
					test = new TestURL(getAlertID());
					test.init(entity);
					test.init(dir, file);
					addTestCase(test);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	protected void scan() {
	}

}