/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.scan;


class TestServerJRun extends TestServerDefault {

    public String toString() {
        return "TestServerJRun";
    }
    
	public String getTestName() {
		return "Server JRun";
	}

	protected int getAlertID() {
		return 3;
	}

	protected void init(ParsedEntity entity) throws Exception {
		super.init(entity);
		
		addTest("//WEB-INF","web.xml");		// info leak by Foundstone
		addTest("//WEB-INF","webapp.properties");	//dito

		// JRUN 4.0
		addTest("/jstl-war","index.html");
		addTest("/compass","logon.jsp");
		addTest("/travelnet","home.jsp");
		addTest("/worldmusic/action","cdlist");
		addTest("/worldmusic/action","catalog");
		addTest("/techniques/servlets","index.html");
		addTest("/ws-client","loanCalculation.jsp");
		addTest("/flash/java/javabean","FlashJavaBean.html");
		addTest("/SmarTicketApp","index.html");
		addTest("/","databasenotes.html");

	}

}